/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.event;

import java.util.LinkedList;
import java.util.List;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.event.PhaseFinishedEvent;
import org.drugis.common.threading.event.PhaseStartedEvent;
import org.drugis.common.threading.event.TaskAbortedEvent;
import org.drugis.common.threading.event.TaskEvent;
import org.drugis.common.threading.event.TaskFailedEvent;
import org.drugis.common.threading.event.TaskFinishedEvent;
import org.drugis.common.threading.event.TaskProgressEvent;
import org.drugis.common.threading.event.TaskStartedEvent;

public class ListenerManager {
    private final Task d_source;
    private List<TaskListener> d_listeners = new LinkedList<TaskListener>();

    public ListenerManager(Task source) {
        this.d_source = source;
    }

    public void addTaskListener(TaskListener l) {
        this.d_listeners.add(l);
    }

    public void removeTaskListener(TaskListener l) {
        this.d_listeners.remove(l);
    }

    public void fireEvent(TaskEvent event) {
        TaskListener[] listeners;
        TaskListener[] taskListenerArray = listeners = this.d_listeners.toArray(new TaskListener[0]);
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            TaskListener l = taskListenerArray[n2];
            l.taskEvent(event);
            ++n2;
        }
    }

    public void fireTaskStarted() {
        this.fireEvent(new TaskStartedEvent(this.d_source));
    }

    public void fireTaskFinished() {
        this.fireEvent(new TaskFinishedEvent(this.d_source));
    }

    public void fireTaskAborted() {
        this.fireEvent(new TaskAbortedEvent(this.d_source));
    }

    public void fireTaskFailed(Throwable cause) {
        this.fireEvent(new TaskFailedEvent(this.d_source, cause));
    }

    public void fireTaskProgress(int iter, int max) {
        this.fireEvent(new TaskProgressEvent(this.d_source, iter, max));
    }

    public void firePhaseStarted(Task phase) {
        this.fireEvent(new PhaseStartedEvent(this.d_source, phase));
    }

    public void firePhaseFinished(Task phase) {
        this.fireEvent(new PhaseFinishedEvent(this.d_source, phase));
    }
}

