/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading.activity;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.activity.Condition;
import org.drugis.common.threading.activity.Transition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DecisionTransition
implements Transition {
    private final Task d_source;
    private final Task d_ifTask;
    private final Task d_elTask;
    private final Condition d_condition;

    public DecisionTransition(Task source, Task ifTask, Task elTask, Condition condition) {
        this.d_source = source;
        this.d_ifTask = ifTask;
        this.d_elTask = elTask;
        this.d_condition = condition;
    }

    @Override
    public List<Task> getSources() {
        return Collections.singletonList(this.d_source);
    }

    @Override
    public List<Task> getTargets() {
        ArrayList<Task> l = new ArrayList<Task>();
        l.add(this.d_ifTask);
        l.add(this.d_elTask);
        return l;
    }

    @Override
    public boolean isReady() {
        return this.d_source.isFinished();
    }

    @Override
    public List<Task> transition() {
        if (!this.isReady()) {
            throw new RuntimeException("Not ready for transition.");
        }
        if (this.d_condition.evaluate()) {
            return Collections.singletonList(this.d_ifTask);
        }
        return Collections.singletonList(this.d_elTask);
    }
}

