/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.common.threading.CompositeTask;
import org.drugis.common.threading.SimpleTask;
import org.drugis.common.threading.SuspendableThreadWrapper;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.event.TaskEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ThreadHandler
extends AbstractObservable {
    public static final String PROPERTY_RUNNING_THREADS = "runningThreads";
    public static final String PROPERTY_QUEUED_THREADS = "queuedThreads";
    public static final String PROPERTY_FAILED_TASK = "failedTask";
    private final int d_numCores;
    LinkedList<Task> d_scheduledTasks;
    LinkedList<SuspendableThreadWrapper> d_runningTasks;
    Thread d_cleaner;
    private TaskFailureObserver d_failureObserver = new TaskFailureObserver();
    private static ThreadHandler d_singleton;
    Map<SimpleTask, SuspendableThreadWrapper> d_wrappers = new HashMap<SimpleTask, SuspendableThreadWrapper>();

    private ThreadHandler() {
        this.d_numCores = Runtime.getRuntime().availableProcessors();
        this.d_scheduledTasks = new LinkedList();
        this.d_runningTasks = new LinkedList();
        this.d_cleaner = new Thread(new RunQueueCleaner());
        this.d_cleaner.start();
    }

    public List<SuspendableThreadWrapper> getThreadsToRun(int n) {
        ArrayList<SimpleTask> toRun = new ArrayList<SimpleTask>(n);
        int i = 0;
        while (toRun.size() < n && i < this.d_scheduledTasks.size()) {
            Task task = this.d_scheduledTasks.get(i);
            if (task.isFinished() || task.isFailed() || task.isAborted()) {
                this.d_scheduledTasks.remove(i);
                continue;
            }
            if (task instanceof SimpleTask) {
                this.add(toRun, (SimpleTask)this.d_scheduledTasks.get(i));
                ++i;
                continue;
            }
            if (task instanceof CompositeTask) {
                CompositeTask compositeTask = (CompositeTask)task;
                if (!compositeTask.isStarted()) {
                    compositeTask.start();
                }
                List<SimpleTask> next = compositeTask.getNextTasks();
                int j = 0;
                while (j < next.size() && toRun.size() < n) {
                    this.add(toRun, next.get(j));
                    ++j;
                }
                ++i;
                continue;
            }
            throw new RuntimeException("Unhandled Task type: " + task.getClass().getName());
        }
        return this.getWrappers(toRun);
    }

    private void add(List<SimpleTask> toRun, SimpleTask simpleTask) {
        if (!toRun.contains(simpleTask)) {
            toRun.add(simpleTask);
        }
    }

    public static ThreadHandler getInstance() {
        if (d_singleton == null) {
            d_singleton = new ThreadHandler();
        }
        return d_singleton;
    }

    public int getRunningThreads() {
        return this.d_runningTasks.size();
    }

    public int getQueuedThreads() {
        return this.d_scheduledTasks.size();
    }

    public void scheduleTask(Task r) {
        this.scheduleTasks(Collections.singleton(r));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scheduleTasks(Collection<? extends Task> newTasks) {
        LinkedList<SuspendableThreadWrapper> linkedList = this.d_runningTasks;
        synchronized (linkedList) {
            this.d_scheduledTasks.removeAll(newTasks);
            this.d_scheduledTasks.addAll(0, newTasks);
            this.firePropertyChange(PROPERTY_QUEUED_THREADS, null, this.d_scheduledTasks.size());
        }
    }

    private LinkedList<SuspendableThreadWrapper> getWrappers(Collection<SimpleTask> newRunnables) {
        this.vacuumWrappers();
        LinkedList<SuspendableThreadWrapper> newList = new LinkedList<SuspendableThreadWrapper>();
        for (SimpleTask r : newRunnables) {
            SuspendableThreadWrapper w = this.d_wrappers.get(r);
            if (w == null) {
                w = new SuspendableThreadWrapper(r);
                r.addTaskListener(this.d_failureObserver);
                this.d_wrappers.put(r, w);
            }
            newList.add(w);
        }
        return newList;
    }

    private void vacuumWrappers() {
        ArrayList<Task> toRemove = new ArrayList<Task>(this.d_wrappers.keySet().size());
        for (Task task : this.d_wrappers.keySet()) {
            if (!task.isFinished()) continue;
            toRemove.add(task);
        }
        for (Task task : toRemove) {
            task.removeTaskListener(this.d_failureObserver);
            this.d_wrappers.remove(task);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Task> getRunningTasks() {
        ArrayList<Task> tasks = new ArrayList<Task>();
        LinkedList<SuspendableThreadWrapper> linkedList = this.d_runningTasks;
        synchronized (linkedList) {
            for (SuspendableThreadWrapper w : this.d_runningTasks) {
                tasks.add((SimpleTask)w.getRunnable());
            }
        }
        return tasks;
    }

    protected List<Task> getScheduledTasks() {
        return Collections.unmodifiableList(this.d_scheduledTasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        LinkedList<SuspendableThreadWrapper> linkedList = this.d_runningTasks;
        synchronized (linkedList) {
            this.terminateTasks(this.d_wrappers.values());
            this.d_scheduledTasks.clear();
            this.vacuumWrappers();
        }
        this.firePropertyChange(PROPERTY_QUEUED_THREADS, null, this.d_scheduledTasks.size());
        this.firePropertyChange(PROPERTY_RUNNING_THREADS, null, this.d_runningTasks.size());
    }

    private void terminateTasks(Collection<SuspendableThreadWrapper> tasks) {
        for (SuspendableThreadWrapper thread : tasks) {
            thread.terminate();
        }
    }

    private class RunQueueCleaner
    implements Runnable {
        private RunQueueCleaner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                LinkedList<SuspendableThreadWrapper> linkedList = ThreadHandler.this.d_runningTasks;
                synchronized (linkedList) {
                    List<SuspendableThreadWrapper> toRun = ThreadHandler.this.getThreadsToRun(ThreadHandler.this.d_numCores);
                    LinkedList<SuspendableThreadWrapper> toStop = new LinkedList<SuspendableThreadWrapper>(ThreadHandler.this.d_runningTasks);
                    toStop.removeAll(toRun);
                    toRun.removeAll(ThreadHandler.this.d_runningTasks);
                    for (SuspendableThreadWrapper t : toStop) {
                        if (!t.isTerminated()) {
                            if (!t.suspend()) continue;
                            ThreadHandler.this.d_runningTasks.remove(t);
                            continue;
                        }
                        ThreadHandler.this.d_runningTasks.remove(t);
                    }
                    int availableSlots = ThreadHandler.this.d_numCores - ThreadHandler.this.d_runningTasks.size();
                    int i = 0;
                    while (i < availableSlots && i < toRun.size()) {
                        SuspendableThreadWrapper t = toRun.get(i);
                        t.start();
                        ThreadHandler.this.d_runningTasks.add(t);
                        ++i;
                    }
                    ThreadHandler.this.firePropertyChange(ThreadHandler.PROPERTY_QUEUED_THREADS, null, ThreadHandler.this.d_scheduledTasks.size());
                    ThreadHandler.this.firePropertyChange(ThreadHandler.PROPERTY_RUNNING_THREADS, null, ThreadHandler.this.d_runningTasks.size());
                }
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private class TaskFailureObserver
    implements TaskListener {
        private TaskFailureObserver() {
        }

        public void taskEvent(TaskEvent event) {
            if (event.getType() == TaskEvent.EventType.TASK_FAILED) {
                ThreadHandler.this.firePropertyChange(ThreadHandler.PROPERTY_FAILED_TASK, null, event);
            }
        }
    }
}

