/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import org.drugis.common.threading.Task;
import org.drugis.common.threading.ThreadHandler;
import org.drugis.common.threading.activity.ActivityModel;
import org.drugis.common.threading.activity.ActivityTask;

public class TaskUtil {
    public static void run(ActivityModel model) throws InterruptedException {
        TaskUtil.run(new ActivityTask(model));
    }

    public static void run(Task task) throws InterruptedException {
        ThreadHandler th = ThreadHandler.getInstance();
        th.scheduleTask(task);
        TaskUtil.waitUntilReady(task);
    }

    public static void waitUntilReady(Task task) throws InterruptedException {
        while (!(task.isFinished() || task.isFailed() || task.isAborted())) {
            Thread.sleep(100L);
        }
        if (task.isFailed()) {
            throw new RuntimeException("Task failed", task.getFailureCause());
        }
    }
}

