/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.threading;

import org.drugis.common.threading.AbstractSuspendable;
import org.drugis.common.threading.IterativeComputation;
import org.drugis.common.threading.SimpleSuspendableTask;
import org.drugis.common.threading.event.ListenerManager;

public class IterativeTask
extends SimpleSuspendableTask {
    private final String d_str;

    public IterativeTask(IterativeComputation computation, String str) {
        super(new IterativeSuspendable(computation));
        this.d_str = str;
        ((IterativeSuspendable)this.d_suspendable).setListenerManager(this.d_mgr);
    }

    public IterativeTask(IterativeComputation computation) {
        this(computation, computation.toString());
    }

    public void setReportingInterval(int interval) {
        ((IterativeSuspendable)this.d_suspendable).setReportingInterval(interval);
    }

    public String toString() {
        return this.d_str;
    }

    static class IterativeSuspendable
    extends AbstractSuspendable {
        private ListenerManager d_mgr;
        private final IterativeComputation d_computation;
        private int d_interval = 0;

        public IterativeSuspendable(IterativeComputation computation) {
            this.d_computation = computation;
        }

        public void run() {
            this.d_computation.initialize();
            this.waitIfSuspended();
            while (this.d_computation.getIteration() < this.d_computation.getTotalIterations()) {
                if (this.d_interval > 0 && this.d_computation.getIteration() % this.d_interval == 0) {
                    this.fireProgress();
                }
                this.d_computation.step();
                this.waitIfSuspended();
            }
            if (this.d_interval > 0) {
                this.fireProgress();
            }
            this.d_computation.finish();
        }

        private void fireProgress() {
            this.d_mgr.fireTaskProgress(this.d_computation.getIteration(), this.d_computation.getTotalIterations());
        }

        public void setListenerManager(ListenerManager mgr) {
            this.d_mgr = mgr;
        }

        public void setReportingInterval(int interval) {
            this.d_interval = interval;
        }
    }
}

