/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.stat;

import org.drugis.common.stat.Statistics;

public class DichotomousDescriptives {
    public final double d_correction;

    public DichotomousDescriptives() {
        this(false);
    }

    public DichotomousDescriptives(boolean corrected) {
        this.d_correction = corrected ? 0.5 : 0.0;
    }

    public double logOddsRatio(int a, int n, int c, int m) {
        return this.logOdds(c, m) - this.logOdds(a, n);
    }

    public double logOddsRatioError(int a, int n, int c, int m) {
        int b = n - a;
        int d = m - c;
        return Math.sqrt(1.0 / ((double)a + this.d_correction) + 1.0 / ((double)b + this.d_correction) + 1.0 / ((double)c + this.d_correction) + 1.0 / ((double)d + this.d_correction));
    }

    public double logOdds(int a, int n) {
        return Statistics.logit(this.risk(a, n));
    }

    public double risk(int a, int n) {
        return ((double)a + this.d_correction) / ((double)n + 2.0 * this.d_correction);
    }
}

