/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.gui.task;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.drugis.common.beans.AbstractObservable;
import org.drugis.common.gui.TextProgressModel;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.TaskListener;
import org.drugis.common.threading.event.PhaseEvent;
import org.drugis.common.threading.event.TaskEvent;
import org.drugis.common.threading.event.TaskProgressEvent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaskProgressModel
extends AbstractObservable
implements TextProgressModel {
    public static final String DONE_TEXT = "Done!";
    public static final String WAITING_TEXT = "waiting";
    public static final String FAILED_TEXT = "failed";
    public static final String ABORTED_TEXT = "Aborted";
    private Task d_task;
    private Double d_progress;
    private Map<Task, Double> d_phaseProgress = new HashMap<Task, Double>();
    private List<Task> d_phases = new ArrayList<Task>();
    private boolean d_determinate;
    private PhaseListener d_phaseListener = new PhaseListener();
    private Object d_lock = new Object();
    private TaskListener d_taskListener = new MyTaskListener();

    public TaskProgressModel(Task task) {
        this.setTask(task);
    }

    public void setTask(Task task) {
        if (this.d_task != null) {
            this.d_task.removeTaskListener(this.d_taskListener);
        }
        this.d_task = task;
        this.removePhases();
        this.setDeterminate(false);
        task.addTaskListener(this.d_taskListener);
    }

    public Task getTask() {
        return this.d_task;
    }

    private void removePhases() {
        for (Task t : this.d_phases) {
            t.removeTaskListener(this.d_phaseListener);
        }
        this.d_phases.clear();
        this.d_phaseProgress.clear();
    }

    private boolean calcDeterminate() {
        if (this.d_phases.isEmpty()) {
            return false;
        }
        for (Task p : this.d_phases) {
            if (this.d_phaseProgress.get(p) != null) continue;
            return false;
        }
        return true;
    }

    protected Double calcProgress() {
        HashSet<Double> values = new HashSet<Double>(this.d_phaseProgress.values());
        values.remove(null);
        if (!values.isEmpty()) {
            return Collections.min(values);
        }
        return 0.0;
    }

    @Override
    public boolean getDeterminate() {
        return this.d_determinate;
    }

    @Override
    public Double getProgress() {
        return this.d_progress;
    }

    private double calcProgress(TaskProgressEvent evt) {
        return (double)evt.getIteration() / (double)evt.getTotalIterations();
    }

    @Override
    public String getText() {
        String taskName = this.d_task.toString();
        List<String> phaseStrings = this.getPhaseStrings();
        String phaseString = " (" + StringUtils.join(phaseStrings, ", ") + ")";
        if (!this.d_task.isStarted()) {
            return String.valueOf(taskName) + " (" + WAITING_TEXT + ")";
        }
        if (this.d_task.isFinished()) {
            return DONE_TEXT;
        }
        if (this.d_task.isFailed()) {
            return String.valueOf(taskName) + " " + FAILED_TEXT + ": " + this.d_task.getFailureCause().getMessage();
        }
        if (this.d_task.isAborted()) {
            return String.valueOf(taskName) + ": " + ABORTED_TEXT;
        }
        if (!this.d_phases.isEmpty()) {
            return String.valueOf(taskName) + phaseString;
        }
        return String.valueOf(taskName) + ": " + this.formatProgress(this.getDeterminate() ? this.d_progress : null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPhaseStrings() {
        ArrayList<String> phaseStrings = new ArrayList<String>();
        Object object = this.d_lock;
        synchronized (object) {
            for (Task p : this.d_phases) {
                phaseStrings.add(String.valueOf(p.toString()) + ": " + this.formatProgress(this.d_phaseProgress.get(p)));
            }
        }
        return phaseStrings;
    }

    private String formatProgress(Double progress) {
        if (progress == null) {
            return "?";
        }
        Long round = Math.round(100.0 * progress);
        return String.valueOf(round.toString()) + "%";
    }

    private void setProgress(Double progress) {
        Double oldValue = this.d_progress;
        this.d_progress = progress;
        this.firePropertyChange("progress", oldValue, this.d_progress);
        this.firePropertyChange("text", null, this.getText());
    }

    private void setDeterminate(boolean determinate) {
        boolean oldValue = this.d_determinate;
        this.d_determinate = determinate;
        this.firePropertyChange("determinate", oldValue, this.d_determinate);
    }

    private class MyTaskListener
    implements TaskListener {
        private MyTaskListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskEvent(TaskEvent e) {
            Object object = TaskProgressModel.this.d_lock;
            synchronized (object) {
                if (e.getType().equals((Object)TaskEvent.EventType.TASK_STARTED)) {
                    TaskProgressModel.this.setProgress(0.0);
                } else if (e.getType().equals((Object)TaskEvent.EventType.TASK_PROGRESS)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(TaskProgressModel.this.calcProgress((TaskProgressEvent)e));
                } else if (e.getType().equals((Object)TaskEvent.EventType.TASK_FINISHED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(1.0);
                } else if (e.getType().equals((Object)TaskEvent.EventType.TASK_FAILED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(0.0);
                } else if (e.getType().equals((Object)TaskEvent.EventType.TASK_ABORTED)) {
                    TaskProgressModel.this.setDeterminate(true);
                    TaskProgressModel.this.setProgress(0.0);
                } else if (e instanceof PhaseEvent) {
                    PhaseEvent evt = (PhaseEvent)e;
                    Task phase = evt.getPhase();
                    if (e.getType().equals((Object)TaskEvent.EventType.PHASE_STARTED)) {
                        TaskProgressModel.this.d_phases.add(phase);
                        phase.addTaskListener(TaskProgressModel.this.d_phaseListener);
                        TaskProgressModel.this.d_phaseProgress.put(phase, null);
                    } else if (e.getType().equals((Object)TaskEvent.EventType.PHASE_FINISHED)) {
                        phase.removeTaskListener(TaskProgressModel.this.d_phaseListener);
                        TaskProgressModel.this.d_phaseProgress.remove(phase);
                        TaskProgressModel.this.d_phases.remove(phase);
                    }
                    TaskProgressModel.this.setDeterminate(TaskProgressModel.this.calcDeterminate());
                    TaskProgressModel.this.setProgress(TaskProgressModel.this.calcProgress());
                }
            }
        }
    }

    private final class PhaseListener
    implements TaskListener {
        private PhaseListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void taskEvent(TaskEvent event) {
            Object object = TaskProgressModel.this.d_lock;
            synchronized (object) {
                if (event.getType().equals((Object)TaskEvent.EventType.TASK_PROGRESS)) {
                    TaskProgressModel.this.d_phaseProgress.put(event.getSource(), TaskProgressModel.this.calcProgress((TaskProgressEvent)event));
                    TaskProgressModel.this.setDeterminate(TaskProgressModel.this.calcDeterminate());
                    TaskProgressModel.this.setProgress(TaskProgressModel.this.calcProgress());
                }
            }
        }
    }
}

