/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import org.drugis.common.gui.TextProgressModel;

public class TextProgressBar
extends JProgressBar {
    public TextProgressBar(TextProgressModel model) {
        this.setIndeterminate(!model.getDeterminate());
        this.setString(model.getText());
        this.setStringPainted(true);
        if (model.getDeterminate()) {
            this.setValue(this.proportionToPercentage(model.getProgress()));
        } else {
            this.setValue(0);
        }
        model.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("progress")) {
                    TextProgressBar.this.invokeSetValue(TextProgressBar.this.proportionToPercentage((Double)e.getNewValue()));
                } else if (e.getPropertyName().equals("determinate")) {
                    TextProgressBar.this.invokeSetIndeterminate((Boolean)e.getNewValue() == false);
                } else if (e.getPropertyName().equals("text")) {
                    TextProgressBar.this.invokeSetString((String)e.getNewValue());
                }
            }
        });
    }

    private void invokeSetString(final String v) {
        Runnable r = new Runnable(){

            public void run() {
                TextProgressBar.this.setString(v);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void invokeSetIndeterminate(final boolean v) {
        Runnable r = new Runnable(){

            public void run() {
                TextProgressBar.this.setIndeterminate(v);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private void invokeSetValue(final int v) {
        Runnable r = new Runnable(){

            public void run() {
                TextProgressBar.this.setValue(v);
            }
        };
        SwingUtilities.invokeLater(r);
    }

    private int proportionToPercentage(double val) {
        return (int)Math.round(100.0 * val);
    }
}

