/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.gui;

import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import org.drugis.common.Interval;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NumberAndIntervalFormat
extends Format {
    private static final DecimalFormat s_fmt = new DecimalFormat("#0.00");

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        if (obj instanceof Interval) {
            return toAppendTo.append(this.format((Interval)obj));
        }
        if (obj instanceof Double) {
            return toAppendTo.append(this.format((Double)obj));
        }
        return toAppendTo.append(obj.toString());
    }

    public String format(Interval<Double> interval) {
        return "[" + s_fmt.format(interval.getLowerBound()) + " - " + s_fmt.format(interval.getUpperBound()) + "]";
    }

    public String format(Double x) {
        return s_fmt.format(x);
    }

    @Override
    public Object parseObject(String source, ParsePosition pos) {
        return null;
    }
}

