/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.gui;

import com.jgoodies.looks.plastic.PlasticLookAndFeel;
import com.jgoodies.looks.windows.WindowsLookAndFeel;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import org.apache.commons.lang.StringEscapeUtils;

public class GUIHelper {
    private static final Pattern wrapRE = Pattern.compile(".{0,79}(?:\\S(?:-| |$)|$)");

    public static void initializeLookAndFeel() {
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows")) {
                UIManager.setLookAndFeel((LookAndFeel)((Object)new WindowsLookAndFeel()));
            } else if (!osName.startsWith("Mac")) {
                try {
                    UIManager.setLookAndFeel("com.sun.java.swing.plaf.gtk.GTKLookAndFeel");
                }
                catch (Exception e) {
                    UIManager.setLookAndFeel(new PlasticLookAndFeel());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String[] makeParts(String str) {
        if (str != null && str != "") {
            LinkedList<String> list = new LinkedList<String>();
            Matcher m = wrapRE.matcher(str);
            while (m.find()) {
                list.add(m.group());
            }
            return list.toArray(new String[0]);
        }
        return new String[0];
    }

    public static String wordWrap(String input, boolean surround) {
        String[] arr = GUIHelper.makeParts(StringEscapeUtils.escapeHtml(input));
        String resStr = "";
        String[] stringArray = arr;
        int n = arr.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.length() >= 1) {
                if (!resStr.equals("")) {
                    resStr = String.valueOf(resStr) + "<br>";
                }
                resStr = String.valueOf(resStr) + s;
            }
            ++n2;
        }
        if (surround) {
            return "<html>" + resStr + "</html>";
        }
        return resStr;
    }

    public static void centerWindow(Window window) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension fsize = window.getSize();
        int xLoc = (int)(screenSize.getWidth() / 2.0 - fsize.getWidth() / 2.0);
        int yLoc = (int)(screenSize.getHeight() / 2.0 - fsize.getHeight() / 2.0);
        window.setLocation(new Point(xLoc, yLoc));
    }

    public static void centerWindow(Window window, Window parent) {
        Point parentLocation = parent.getLocation();
        Dimension parentDim = parent.getSize();
        Dimension fsize = window.getSize();
        int xLoc = (int)parentLocation.getX() + (int)(parentDim.getWidth() / 2.0 - fsize.getWidth() / 2.0);
        int yLoc = (int)parentLocation.getY() + (int)(parentDim.getHeight() / 2.0 - fsize.getHeight() / 2.0);
        window.setLocation(new Point(xLoc, yLoc));
    }

    public static String createToolTip(String text) {
        if (text != null && text.trim().length() > 0) {
            return GUIHelper.wordWrap(text, true);
        }
        return null;
    }
}

