/*
 * Decompiled with CFR 0.152.
 */
package org.drugis.common.gui;

import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;

public abstract class FileDialog {
    static File d_currentDirectory = null;
    protected JFileChooser d_fileChooser = new JFileChooser();
    private boolean d_lastSuccess = true;

    public static String fixExtension(String absPath, String ext) {
        if (ext == null || ext.equals("")) {
            return absPath;
        }
        if (absPath.toLowerCase().substring(absPath.lastIndexOf(46) + 1, absPath.length()).equals(ext)) {
            return absPath;
        }
        return String.valueOf(absPath) + "." + ext;
    }

    protected void setLastSuccess(boolean lastSuccess) {
        this.d_lastSuccess = lastSuccess;
    }

    public FileDialog(Component frame, String extension, String description) {
        this(frame, new String[]{extension}, new String[]{description});
    }

    public FileDialog(Component frame, String[] extension, String[] description) {
        CustomFileFilter defaultFilter = null;
        int i = 0;
        while (i < extension.length) {
            CustomFileFilter filter = new CustomFileFilter(extension[i], description[i]);
            this.d_fileChooser.addChoosableFileFilter(filter);
            if (i == 0) {
                defaultFilter = filter;
            }
            ++i;
        }
        this.d_fileChooser.setFileFilter(defaultFilter);
        if (d_currentDirectory != null) {
            this.d_fileChooser.setCurrentDirectory(d_currentDirectory);
        }
    }

    protected void handleFileDialogResult(Component frame, int returnVal, String message) {
        d_currentDirectory = this.d_fileChooser.getCurrentDirectory();
        String extension = this.getExtension();
        if (returnVal == 0) {
            String path = FileDialog.fixExtension(this.d_fileChooser.getSelectedFile().getAbsolutePath(), extension);
            try {
                this.doAction(path, extension);
            }
            catch (Exception e1) {
                this.d_lastSuccess = false;
                JOptionPane.showMessageDialog(frame, String.valueOf(message) + "\n" + this.d_fileChooser.getSelectedFile().getAbsolutePath());
                e1.printStackTrace();
            }
        }
    }

    public boolean getLastSuccess() {
        return this.d_lastSuccess;
    }

    private String getExtension() {
        if (this.d_fileChooser.getFileFilter() instanceof CustomFileFilter) {
            return ((CustomFileFilter)this.d_fileChooser.getFileFilter()).getPresentExtension();
        }
        return "";
    }

    public abstract void doAction(String var1, String var2);

    private class CustomFileFilter
    extends FileFilter {
        private final String d_description;
        private final String d_extension;

        public CustomFileFilter(String extension, String description) {
            this.d_extension = extension;
            this.d_description = description;
        }

        public String getDescription() {
            return this.d_description;
        }

        private String getExtension(File f) {
            String ext = null;
            String s = f.getName();
            int i = s.lastIndexOf(46);
            if (i > 0 && i < s.length() - 1) {
                ext = s.substring(i + 1).toLowerCase();
            }
            return ext;
        }

        public String getPresentExtension() {
            return this.d_extension;
        }

        public boolean accept(File f) {
            if (f.isDirectory()) {
                return true;
            }
            String extension = this.getExtension(f);
            if (extension != null) {
                return extension.equals(this.d_extension);
            }
            return false;
        }
    }
}

