/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.util;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.URIResolver;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ColorSpaceCache {
    private static Log log = LogFactory.getLog(class$org$apache$fop$util$ColorSpaceCache == null ? (class$org$apache$fop$util$ColorSpaceCache = ColorSpaceCache.class$("org.apache.fop.util.ColorSpaceCache")) : class$org$apache$fop$util$ColorSpaceCache);
    private URIResolver resolver;
    private Map colorSpaceMap = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$apache$fop$util$ColorSpaceCache;

    public ColorSpaceCache(URIResolver resolver) {
        this.resolver = resolver;
    }

    public ColorSpace get(String base, String iccProfileSrc) {
        ColorSpace colorSpace = null;
        if (!this.colorSpaceMap.containsKey(base + iccProfileSrc)) {
            try {
                ICC_Profile iccProfile = null;
                Source src = this.resolver.resolve(iccProfileSrc, base);
                if (src != null && src instanceof StreamSource) {
                    iccProfile = ICC_Profile.getInstance(((StreamSource)src).getInputStream());
                }
                if (iccProfile != null) {
                    colorSpace = new ICC_ColorSpace(iccProfile);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (colorSpace != null) {
                this.colorSpaceMap.put(base + iccProfileSrc, colorSpace);
            } else {
                log.warn("Color profile '" + iccProfileSrc + "' not found.");
            }
        } else {
            colorSpace = (ColorSpace)this.colorSpaceMap.get(base + iccProfileSrc);
        }
        return colorSpace;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

