/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp.fonts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.render.afp.exceptions.FontRuntimeException;
import org.apache.fop.render.afp.fonts.AFPFont;
import org.apache.fop.render.afp.fonts.CharacterSet;

public class RasterFont
extends AFPFont {
    protected static final Log log = LogFactory.getLog("org.apache.fop.render.afp.fonts");
    private HashMap _characterSets = new HashMap();
    private CharacterSet _characterSet = null;

    public RasterFont(String name) {
        super(name);
    }

    public void addCharacterSet(int size, CharacterSet characterSet) {
        this._characterSets.put(String.valueOf(size), characterSet);
        this._characterSet = characterSet;
    }

    public CharacterSet getCharacterSet(int size) {
        String pointsize = String.valueOf(size / 1000);
        CharacterSet csm = (CharacterSet)this._characterSets.get(pointsize);
        if (csm == null) {
            csm = (CharacterSet)this._characterSets.get(size + "mpt");
        }
        if (csm == null) {
            int distance = Integer.MAX_VALUE;
            Iterator it = this._characterSets.entrySet().iterator();
            while (it.hasNext()) {
                int mpt;
                Map.Entry me = it.next();
                String key = (String)me.getKey();
                if (key.endsWith("mpt") || Math.abs(size - (mpt = Integer.parseInt(key) * 1000)) >= distance) continue;
                distance = Math.abs(size - mpt);
                pointsize = (String)me.getKey();
                csm = (CharacterSet)me.getValue();
            }
            if (csm != null) {
                this._characterSets.put(size + "mpt", csm);
                String msg = "No " + size / 1000 + "pt font " + this._name + " found, substituted with " + pointsize + "pt font";
                log.warn(msg);
            }
        }
        if (csm == null) {
            String msg = "No font found for font " + this._name + " with point size " + pointsize;
            log.error(msg);
            throw new FontRuntimeException(msg);
        }
        return csm;
    }

    public int getFirstChar() {
        Iterator i = this._characterSets.values().iterator();
        if (i.hasNext()) {
            CharacterSet csm = (CharacterSet)i.next();
            return csm.getFirstChar();
        }
        String msg = "getFirstChar() - No character set found for font:" + this._name;
        log.error(msg);
        throw new FontRuntimeException(msg);
    }

    public int getLastChar() {
        Iterator i = this._characterSets.values().iterator();
        if (i.hasNext()) {
            CharacterSet csm = (CharacterSet)i.next();
            return csm.getLastChar();
        }
        String msg = "getLastChar() - No character set found for font:" + this._name;
        log.error(msg);
        throw new FontRuntimeException(msg);
    }

    public int getAscender(int size) {
        return this.getCharacterSet(size).getAscender();
    }

    public int getCapHeight(int size) {
        return this.getCharacterSet(size).getCapHeight();
    }

    public int getDescender(int size) {
        return this.getCharacterSet(size).getDescender();
    }

    public int getXHeight(int size) {
        return this.getCharacterSet(size).getXHeight();
    }

    public int getWidth(int character, int size) {
        return this.getCharacterSet(size).width(character);
    }

    public int[] getWidths(int size) {
        return this.getCharacterSet(size).getWidths();
    }

    public int[] getWidths() {
        return this.getWidths(1000);
    }

    public char mapChar(char c) {
        return this._characterSet.mapChar(c);
    }

    public String getEncoding() {
        return this._characterSet.getEncoding();
    }
}

