/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.table;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.flow.TableRow;
import org.apache.fop.layoutmgr.BreakElement;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.ListElement;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.table.ActiveCell;
import org.apache.fop.layoutmgr.table.EffRow;
import org.apache.fop.layoutmgr.table.GridUnit;
import org.apache.fop.layoutmgr.table.GridUnitPart;
import org.apache.fop.layoutmgr.table.PrimaryGridUnit;
import org.apache.fop.layoutmgr.table.TableContentLayoutManager;
import org.apache.fop.layoutmgr.table.TableContentPosition;
import org.apache.fop.layoutmgr.table.TableHFPenaltyPosition;
import org.apache.fop.layoutmgr.table.TableLayoutManager;

public class TableStepper {
    private static Log log = LogFactory.getLog(class$org$apache$fop$layoutmgr$table$TableStepper == null ? (class$org$apache$fop$layoutmgr$table$TableStepper = TableStepper.class$("org.apache.fop.layoutmgr.table.TableStepper")) : class$org$apache$fop$layoutmgr$table$TableStepper);
    private TableContentLayoutManager tclm;
    private EffRow[] rowGroup;
    private int columnCount;
    private int totalHeight;
    private int activeRowIndex;
    private boolean rowBacktrackForLastStep;
    private boolean skippedStep;
    private List activeCells = new LinkedList();
    static /* synthetic */ Class class$org$apache$fop$layoutmgr$table$TableStepper;

    public TableStepper(TableContentLayoutManager tclm) {
        this.tclm = tclm;
    }

    private void setup(int columnCount) {
        this.columnCount = columnCount;
        this.activeRowIndex = 0;
    }

    private EffRow getActiveRow() {
        return this.rowGroup[this.activeRowIndex];
    }

    private GridUnit getActiveGridUnit(int column) {
        return this.getActiveRow().safelyGetGridUnit(column);
    }

    private void calcTotalHeight() {
        this.totalHeight = 0;
        for (int i = 0; i < this.rowGroup.length; ++i) {
            this.totalHeight += this.rowGroup[i].getHeight().opt;
        }
        if (log.isDebugEnabled()) {
            log.debug("totalHeight=" + this.totalHeight);
        }
    }

    private int getMaxRemainingHeight() {
        int maxW = 0;
        if (!this.rowBacktrackForLastStep) {
            Iterator iter = this.activeCells.iterator();
            while (iter.hasNext()) {
                maxW = Math.max(maxW, ((ActiveCell)iter.next()).getRemainingHeight(this.activeRowIndex, this.rowGroup));
            }
        }
        for (int i = this.activeRowIndex + (this.rowBacktrackForLastStep ? 0 : 1); i < this.rowGroup.length; ++i) {
            maxW += this.rowGroup[i].getHeight().opt;
        }
        log.debug("maxRemainingHeight=" + maxW);
        return maxW;
    }

    private void initializeElementLists() {
        log.trace("Entering initializeElementLists()");
        EffRow row = this.getActiveRow();
        for (int i = 0; i < this.columnCount; ++i) {
            GridUnit gu = this.getActiveGridUnit(i);
            if (gu == null || gu.isEmpty() || !gu.isPrimary()) continue;
            this.activeCells.add(new ActiveCell((PrimaryGridUnit)gu, row, this.activeRowIndex, this.rowGroup, this.getTableLM()));
        }
    }

    public LinkedList getCombinedKnuthElementsForRowGroup(LayoutContext context, EffRow[] rowGroup, int maxColumnCount, int bodyType) {
        int step;
        this.rowGroup = rowGroup;
        this.setup(maxColumnCount);
        this.initializeElementLists();
        this.calcTotalHeight();
        boolean signalKeepWithNext = false;
        int laststep = 0;
        int addedBoxLen = 0;
        TableContentPosition lastTCPos = null;
        LinkedList<ListElement> returnList = new LinkedList<ListElement>();
        while ((step = this.getNextStep()) >= 0) {
            int normalRow = this.activeRowIndex;
            int increase = step - laststep;
            int penaltyOrGlueLen = step + this.getMaxRemainingHeight() - this.totalHeight;
            int boxLen = step - addedBoxLen - Math.max(0, penaltyOrGlueLen);
            addedBoxLen += boxLen;
            boolean forcedBreak = false;
            int breakClass = -1;
            ArrayList<GridUnitPart> gridUnitParts = new ArrayList<GridUnitPart>(maxColumnCount);
            Iterator iter = this.activeCells.iterator();
            while (iter.hasNext()) {
                ActiveCell activeCell = (ActiveCell)iter.next();
                if (!activeCell.contributesContent()) continue;
                GridUnitPart gup = activeCell.createGridUnitPart();
                gridUnitParts.add(gup);
                forcedBreak = activeCell.isLastForcedBreak();
                if (forcedBreak) {
                    breakClass = activeCell.getLastBreakClass();
                }
                if (returnList.size() != 0 || !gup.isFirstPart() || !gup.mustKeepWithPrevious()) continue;
                context.setFlags(1024);
            }
            TableContentPosition tcpos = new TableContentPosition(this.getTableLM(), gridUnitParts, rowGroup[normalRow]);
            if (returnList.size() == 0) {
                tcpos.setFlag(1, true);
            }
            lastTCPos = tcpos;
            if (log.isDebugEnabled()) {
                log.debug(" - backtrack=" + this.rowBacktrackForLastStep + " - row=" + this.activeRowIndex + " - " + tcpos);
            }
            returnList.add(new KnuthBox(boxLen, tcpos, false));
            int effPenaltyLen = Math.max(0, penaltyOrGlueLen);
            TableHFPenaltyPosition penaltyPos = new TableHFPenaltyPosition(this.getTableLM());
            if (bodyType == 0) {
                if (!this.getTableLM().getTable().omitHeaderAtBreak()) {
                    effPenaltyLen += this.tclm.getHeaderNetHeight();
                    penaltyPos.headerElements = this.tclm.getHeaderElements();
                }
                if (!this.getTableLM().getTable().omitFooterAtBreak()) {
                    effPenaltyLen += this.tclm.getFooterNetHeight();
                    penaltyPos.footerElements = this.tclm.getFooterElements();
                }
            }
            int p = 0;
            boolean allCellsHaveContributed = true;
            signalKeepWithNext = false;
            Iterator iter2 = this.activeCells.iterator();
            while (iter2.hasNext()) {
                ActiveCell activeCell = (ActiveCell)iter2.next();
                allCellsHaveContributed &= activeCell.hasStarted();
                signalKeepWithNext |= activeCell.keepWithNextSignal();
            }
            if (!allCellsHaveContributed) {
                p = 900;
            }
            if (signalKeepWithNext || this.getTableLM().mustKeepTogether()) {
                p = 1000;
            }
            if (this.skippedStep) {
                p = 1000;
            }
            if (forcedBreak) {
                if (this.skippedStep) {
                    log.error("This is a conflict situation. The output may be wrong. Please send your FO file to fop-dev@xmlgraphics.apache.org!");
                }
                p = -1000;
            }
            returnList.add(new BreakElement(penaltyPos, effPenaltyLen, p, breakClass, context));
            if (penaltyOrGlueLen < 0) {
                returnList.add(new KnuthGlue(-penaltyOrGlueLen, 0, 0, new Position(null), true));
            }
            if (log.isDebugEnabled()) {
                log.debug("step=" + step + " (+" + increase + ")" + " box=" + boxLen + " penalty=" + penaltyOrGlueLen + " effPenalty=" + effPenaltyLen);
            }
            laststep = step;
        }
        if (signalKeepWithNext) {
            context.setFlags(512);
        }
        if (lastTCPos != null) {
            lastTCPos.setFlag(2, true);
        }
        return returnList;
    }

    private int getNextStep() {
        ActiveCell activeCell;
        log.trace("Entering getNextStep");
        this.goToNextRowIfCurrentFinished();
        int minStep = Integer.MAX_VALUE;
        boolean stepFound = false;
        Iterator iter = this.activeCells.iterator();
        while (iter.hasNext()) {
            activeCell = (ActiveCell)iter.next();
            int nextStep = activeCell.getNextStep();
            if (nextStep <= 0) continue;
            stepFound = true;
            minStep = Math.min(minStep, nextStep);
        }
        if (!stepFound) {
            return -1;
        }
        this.rowBacktrackForLastStep = false;
        this.skippedStep = false;
        iter = this.activeCells.iterator();
        while (iter.hasNext()) {
            activeCell = (ActiveCell)iter.next();
            if (!activeCell.signalMinStep(minStep)) continue;
            if (this.activeRowIndex == 0) {
                log.debug("  First row. Skip this step.");
                this.skippedStep = true;
                continue;
            }
            log.debug("  row-span situation: backtracking to last row");
            this.rowBacktrackForLastStep = true;
        }
        return minStep;
    }

    private void removeCellsEndingOnCurrentRow() {
        Iterator iter = this.activeCells.iterator();
        while (iter.hasNext()) {
            ActiveCell activeCell = (ActiveCell)iter.next();
            if (!activeCell.endsOnRow(this.activeRowIndex)) continue;
            iter.remove();
        }
    }

    private void goToNextRowIfCurrentFinished() {
        boolean currentGridRowFinished = true;
        Iterator iter = this.activeCells.iterator();
        while (iter.hasNext()) {
            ActiveCell activeCell = (ActiveCell)iter.next();
            if (!activeCell.endsOnRow(this.activeRowIndex)) continue;
            currentGridRowFinished &= activeCell.isFinished();
        }
        if (currentGridRowFinished) {
            this.removeCellsEndingOnCurrentRow();
            if (this.activeRowIndex < this.rowGroup.length - 1) {
                TableRow rowFO = this.getActiveRow().getTableRow();
                if (rowFO != null && rowFO.getBreakAfter() != 9) {
                    log.warn(FONode.decorateWithContextInfo("break-after ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.1)", rowFO));
                }
                ++this.activeRowIndex;
                if (log.isDebugEnabled()) {
                    log.debug("===> new row: " + this.activeRowIndex);
                }
                this.initializeElementLists();
                rowFO = this.getActiveRow().getTableRow();
                if (rowFO != null && rowFO.getBreakBefore() != 9) {
                    log.warn(FONode.decorateWithContextInfo("break-before ignored on table-row because of row spanning in progress (See XSL 1.0, 7.19.2)", rowFO));
                }
            }
        }
    }

    private TableLayoutManager getTableLM() {
        return this.tclm.getTableLM();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

