/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;
import org.apache.fop.util.UnclosableInputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class XMLReader
implements ImageReader {
    private Log log = LogFactory.getLog(class$org$apache$fop$image$analyser$XMLReader == null ? (class$org$apache$fop$image$analyser$XMLReader = XMLReader.class$("org.apache.fop.image.analyser.XMLReader")) : class$org$apache$fop$image$analyser$XMLReader);
    private static Map converters = new HashMap();
    static /* synthetic */ Class class$org$apache$fop$image$analyser$XMLReader;

    public static void setConverter(String ns, Converter conv) {
        converters.put(ns, conv);
    }

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        FopImage.ImageInfo info = this.loadImage(uri, fis, ua);
        if (info != null) {
            info.originalURI = uri;
            IOUtils.closeQuietly(fis);
        }
        return info;
    }

    public String getMimeType() {
        return "text/xml";
    }

    protected FopImage.ImageInfo loadImage(String uri, InputStream bis, FOUserAgent ua) {
        return this.createDocument(bis, ua);
    }

    public FopImage.ImageInfo createDocument(InputStream input, FOUserAgent ua) {
        Document doc = null;
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        info.mimeType = this.getMimeType();
        try {
            FopImage.ImageInfo i;
            String ns;
            UnclosableInputStream is = new UnclosableInputStream(input);
            int length = ((InputStream)is).available();
            ((InputStream)is).mark(length);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            doc = dbf.newDocumentBuilder().parse(is);
            info.data = doc;
            Element root = doc.getDocumentElement();
            this.log.debug("XML image namespace: " + root.getAttribute("xmlns"));
            info.str = ns = root.getAttribute("xmlns");
            Converter conv = (Converter)converters.get(ns);
            if (conv != null && (i = conv.convert(doc)) != null) {
                info = i;
            }
        }
        catch (Exception e) {
            this.log.debug("Error while constructing image from XML", e);
            try {
                input.reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return null;
        }
        if (info != null) {
            try {
                input.close();
            }
            catch (IOException io) {
                // empty catch block
            }
        }
        return info;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static interface Converter {
        public FopImage.ImageInfo convert(Document var1);
    }
}

