/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.XmlGraphicsCommonsImage;
import org.apache.xmlgraphics.image.codec.png.PNGDecodeParam;
import org.apache.xmlgraphics.image.codec.png.PNGRed;
import org.apache.xmlgraphics.image.codec.util.SeekableStream;
import org.apache.xmlgraphics.image.rendered.CachableRed;

public class PNGImage
extends XmlGraphicsCommonsImage {
    public PNGImage(FopImage.ImageInfo imgReader) {
        super(imgReader);
        this.loaded = 0;
    }

    protected CachableRed decodeImage(SeekableStream stream) throws IOException {
        PNGDecodeParam param = new PNGDecodeParam();
        param.setPerformGammaCorrection(true);
        param.setDisplayExponent(2.2f);
        PNGRed red = new PNGRed(stream, param);
        String unit = (String)red.getProperty("pixel_units");
        if ("Meters".equals(unit)) {
            this.dpiHorizontal = (float)((Integer)red.getProperty("x_pixels_per_unit")).intValue() * 25.4f / 1000.0f;
            this.dpiVertical = (float)((Integer)red.getProperty("y_pixels_per_unit")).intValue() * 25.4f / 1000.0f;
        }
        return red;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadOriginalData() {
        try {
            this.seekableInput.seek(0L);
            this.raw = IOUtils.toByteArray(this.seekableInput);
        }
        catch (IOException ex) {
            log.error("Error while loading raw image: " + ex.getMessage(), ex);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly(this.inputStream);
            this.inputStream = null;
        }
        return true;
    }
}

