/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.io.IOException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;
import org.apache.fop.util.CMYKColorSpace;

public class JpegImage
extends AbstractFopImage {
    private ICC_Profile iccProfile = null;
    private boolean foundICCProfile = false;
    private boolean hasAPPEMarker = false;

    public JpegImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean loadOriginalData() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ByteArrayOutputStream iccStream = null;
        int index = 0;
        boolean cont = true;
        try {
            int bytesRead;
            byte[] readBuf = new byte[4096];
            while ((bytesRead = this.inputStream.read(readBuf)) != -1) {
                baos.write(readBuf, 0, bytesRead);
            }
        }
        catch (IOException ex) {
            log.error("Error while loading image (Jpeg): " + ex.getMessage(), ex);
            boolean bytesRead = false;
            return bytesRead;
        }
        finally {
            IOUtils.closeQuietly(this.inputStream);
            this.inputStream = null;
        }
        this.raw = baos.toByteArray();
        this.bitsPerPixel = 8;
        this.isTransparent = false;
        if (this.raw.length > index + 2 && this.uByte(this.raw[index]) == 255 && this.uByte(this.raw[index + 1]) == 216) {
            index += 2;
            while (index < this.raw.length && cont) {
                if (this.raw.length > index + 2 && this.uByte(this.raw[index]) == 255) {
                    if (this.uByte(this.raw[index + 1]) == 192 || this.uByte(this.raw[index + 1]) == 194) {
                        this.height = this.calcBytes(this.raw[index + 5], this.raw[index + 6]);
                        this.width = this.calcBytes(this.raw[index + 7], this.raw[index + 8]);
                        if (this.raw[index + 9] == 1) {
                            this.colorSpace = ColorSpace.getInstance(1003);
                        } else if (this.raw[index + 9] == 3) {
                            this.colorSpace = ColorSpace.getInstance(1004);
                        } else if (this.raw[index + 9] == 4) {
                            this.colorSpace = CMYKColorSpace.getInstance();
                        } else {
                            log.error("Unknown ColorSpace for image: ");
                            return false;
                        }
                        if (this.foundICCProfile) {
                            cont = false;
                            break;
                        }
                        index += this.calcBytes(this.raw[index + 2], this.raw[index + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.raw[index + 1]) == 226 && this.raw.length > index + 60) {
                        byte[] iccString = new byte[11];
                        System.arraycopy(this.raw, index + 4, iccString, 0, 11);
                        if ("ICC_PROFILE".equals(new String(iccString))) {
                            int chunkSize = this.calcBytes(this.raw[index + 2], this.raw[index + 3]) + 2;
                            if (iccStream == null) {
                                iccStream = new ByteArrayOutputStream();
                            }
                            iccStream.write(this.raw, index + 18, chunkSize - 18);
                        }
                        index += this.calcBytes(this.raw[index + 2], this.raw[index + 3]) + 2;
                        continue;
                    }
                    if (this.uByte(this.raw[index]) == 255 && this.uByte(this.raw[index + 1]) == 238 && this.uByte(this.raw[index + 2]) == 0 && this.uByte(this.raw[index + 3]) == 14 && "Adobe".equals(new String(this.raw, index + 4, 5))) {
                        this.hasAPPEMarker = true;
                        index += this.calcBytes(this.raw[index + 2], this.raw[index + 3]) + 2;
                        continue;
                    }
                    index += this.calcBytes(this.raw[index + 2], this.raw[index + 3]) + 2;
                    continue;
                }
                cont = false;
            }
        } else {
            log.error("Error while loading JpegImage - Invalid JPEG Header.");
            return false;
        }
        if (iccStream != null && iccStream.size() > 0) {
            int padding = (8 - iccStream.size() % 8) % 8;
            if (padding != 0) {
                try {
                    iccStream.write(new byte[padding]);
                }
                catch (Exception ex) {
                    log.error("Error while aligning ICC stream: " + ex.getMessage(), ex);
                    return false;
                }
            }
            try {
                this.iccProfile = ICC_Profile.getInstance(iccStream.toByteArray());
            }
            catch (IllegalArgumentException iae) {
                log.warn("An ICC profile is present but it is invalid (" + iae.getMessage() + "). The color profile will be ignored. (" + this.getOriginalURI() + ")");
            }
        } else if (this.colorSpace == null) {
            log.error("ColorSpace not specified for JPEG image");
            return false;
        }
        if (this.hasAPPEMarker && this.colorSpace.getType() == 9) {
            if (log.isDebugEnabled()) {
                log.debug("JPEG has an Adobe APPE marker. Note: CMYK Image will be inverted. (" + this.getOriginalURI() + ")");
            }
            this.invertImage = true;
        }
        return true;
    }

    public ICC_Profile getICCProfile() {
        return this.iccProfile;
    }

    private int calcBytes(byte bOne, byte bTwo) {
        return this.uByte(bOne) * 256 + this.uByte(bTwo);
    }

    private int uByte(byte bIn) {
        if (bIn < 0) {
            return 256 + bIn;
        }
        return bIn;
    }
}

