/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import com.sun.media.jai.codec.FileCacheSeekableStream;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.io.InputStream;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.apache.commons.io.IOUtils;
import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;

public class JAIImage
extends AbstractFopImage {
    public JAIImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
    }

    protected boolean loadDimensions() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    protected boolean loadBitmap() {
        if (this.bitmaps == null) {
            this.loadImage();
        }
        return this.bitmaps != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void loadImage() {
        FileCacheSeekableStream seekableInput = null;
        RenderedOp imageOp = null;
        try {
            try {
                int[] tmpMap;
                block13: {
                    block15: {
                        block17: {
                            int transparencyType;
                            ColorModel cm;
                            block16: {
                                seekableInput = new FileCacheSeekableStream(this.inputStream);
                                imageOp = JAI.create((String)"stream", (Object)seekableInput);
                                this.height = imageOp.getHeight();
                                this.width = imageOp.getWidth();
                                cm = imageOp.getColorModel();
                                this.bitsPerPixel = cm.getPixelSize();
                                this.colorSpace = cm.getColorSpace();
                                BufferedImage imageData = imageOp.getAsBufferedImage();
                                tmpMap = imageData.getRGB(0, 0, this.width, this.height, null, 0, this.width);
                                if (!cm.hasAlpha()) break block15;
                                transparencyType = cm.getTransparency();
                                if (transparencyType != 1) break block16;
                                this.isTransparent = false;
                                break block13;
                            }
                            if (transparencyType != 2) break block17;
                            if (cm instanceof IndexColorModel) {
                                this.isTransparent = false;
                                byte[] alphas = new byte[((IndexColorModel)cm).getMapSize()];
                                byte[] reds = new byte[((IndexColorModel)cm).getMapSize()];
                                byte[] greens = new byte[((IndexColorModel)cm).getMapSize()];
                                byte[] blues = new byte[((IndexColorModel)cm).getMapSize()];
                                ((IndexColorModel)cm).getAlphas(alphas);
                                ((IndexColorModel)cm).getReds(reds);
                                ((IndexColorModel)cm).getGreens(greens);
                                ((IndexColorModel)cm).getBlues(blues);
                                for (int i = 0; i < ((IndexColorModel)cm).getMapSize(); ++i) {
                                    if ((alphas[i] & 0xFF) != 0) continue;
                                    this.isTransparent = true;
                                    this.transparentColor = new Color(reds[i] & 0xFF, greens[i] & 0xFF, blues[i] & 0xFF);
                                    break block13;
                                }
                                break block13;
                            } else {
                                this.isTransparent = false;
                            }
                            break block13;
                        }
                        this.isTransparent = false;
                        break block13;
                    }
                    this.isTransparent = false;
                }
                this.bitmaps = new byte[this.width * this.height * 3];
                for (int i = 0; i < this.height; ++i) {
                    for (int j = 0; j < this.width; ++j) {
                        int p = tmpMap[i * this.width + j];
                        int r = p >> 16 & 0xFF;
                        int g = p >> 8 & 0xFF;
                        int b = p & 0xFF;
                        this.bitmaps[3 * (i * this.width + j)] = (byte)(r & 0xFF);
                        this.bitmaps[3 * (i * this.width + j) + 1] = (byte)(g & 0xFF);
                        this.bitmaps[3 * (i * this.width + j) + 2] = (byte)(b & 0xFF);
                    }
                }
                Object var13_17 = null;
            }
            catch (Exception ex) {
                log.error("Error while loading image (JAI): " + ex.getMessage(), ex);
                Object var13_18 = null;
                IOUtils.closeQuietly(this.inputStream);
                this.inputStream = null;
                if (imageOp != null) {
                    imageOp.dispose();
                }
                if (seekableInput == null) return;
                IOUtils.closeQuietly((InputStream)seekableInput);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            IOUtils.closeQuietly(this.inputStream);
            this.inputStream = null;
            if (imageOp != null) {
                imageOp.dispose();
            }
            if (seekableInput == null) throw throwable;
            IOUtils.closeQuietly((InputStream)seekableInput);
            throw throwable;
        }
        IOUtils.closeQuietly(this.inputStream);
        this.inputStream = null;
        if (imageOp != null) {
            imageOp.dispose();
        }
        if (seekableInput == null) return;
        IOUtils.closeQuietly((InputStream)seekableInput);
    }

    protected boolean loadOriginalData() {
        return this.loadDefaultOriginalData();
    }
}

