/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.hyphenation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.reflect.Method;
import java.net.URL;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.hyphenation.Hyphenation;
import org.apache.fop.hyphenation.HyphenationException;
import org.apache.fop.hyphenation.HyphenationTree;
import org.apache.fop.hyphenation.HyphenationTreeCache;
import org.apache.fop.hyphenation.HyphenationTreeResolver;
import org.xml.sax.InputSource;

public class Hyphenator {
    protected static Log log = LogFactory.getLog(class$org$apache$fop$hyphenation$Hyphenator == null ? (class$org$apache$fop$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.hyphenation.Hyphenator")) : class$org$apache$fop$hyphenation$Hyphenator);
    private static HyphenationTreeCache hTreeCache = null;
    private HyphenationTree hyphenTree = null;
    private int remainCharCount = 2;
    private int pushCharCount = 2;
    private static boolean statisticsDump = false;
    static /* synthetic */ Class class$org$apache$fop$hyphenation$Hyphenator;
    static /* synthetic */ Class class$java$lang$Thread;

    public Hyphenator(String lang, String country, int leftMin, int rightMin) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
        this.remainCharCount = leftMin;
        this.pushCharCount = rightMin;
    }

    public static synchronized HyphenationTreeCache getHyphenationTreeCache() {
        if (hTreeCache == null) {
            hTreeCache = new HyphenationTreeCache();
        }
        return hTreeCache;
    }

    public static HyphenationTree getHyphenationTree(String lang, String country) {
        return Hyphenator.getHyphenationTree(lang, country, null);
    }

    public static HyphenationTree getHyphenationTree(String lang, String country, HyphenationTreeResolver resolver) {
        String key = HyphenationTreeCache.constructKey(lang, country);
        HyphenationTreeCache cache = Hyphenator.getHyphenationTreeCache();
        if (cache.isMissing(key)) {
            return null;
        }
        HyphenationTree hTree = Hyphenator.getHyphenationTreeCache().getHyphenationTree(lang, country);
        if (hTree != null) {
            return hTree;
        }
        if (resolver != null) {
            hTree = Hyphenator.getUserHyphenationTree(key, resolver);
        }
        if (hTree == null) {
            hTree = Hyphenator.getFopHyphenationTree(key);
        }
        if (hTree != null) {
            cache.cache(key, hTree);
        } else {
            log.error("Couldn't find hyphenation pattern " + key);
            cache.noteMissing(key);
        }
        return hTree;
    }

    private static InputStream getResourceStream(String key) {
        InputStream is = null;
        try {
            Method getCCL = (class$java$lang$Thread == null ? (class$java$lang$Thread = Hyphenator.class$("java.lang.Thread")) : class$java$lang$Thread).getMethod("getContextClassLoader", new Class[0]);
            if (getCCL != null) {
                ClassLoader contextClassLoader = (ClassLoader)getCCL.invoke((Object)Thread.currentThread(), new Object[0]);
                is = contextClassLoader.getResourceAsStream("hyph/" + key + ".hyp");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (is == null) {
            is = (class$org$apache$fop$hyphenation$Hyphenator == null ? (class$org$apache$fop$hyphenation$Hyphenator = Hyphenator.class$("org.apache.fop.hyphenation.Hyphenator")) : class$org$apache$fop$hyphenation$Hyphenator).getResourceAsStream("/hyph/" + key + ".hyp");
        }
        return is;
    }

    private static HyphenationTree readHyphenationTree(InputStream in) {
        HyphenationTree hTree = null;
        try {
            ObjectInputStream ois = new ObjectInputStream(in);
            hTree = (HyphenationTree)ois.readObject();
        }
        catch (IOException ioe) {
            log.error("I/O error while loading precompiled hyphenation pattern file", ioe);
        }
        catch (ClassNotFoundException cnfe) {
            log.error("Error while reading hyphenation object from file", cnfe);
        }
        return hTree;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HyphenationTree getFopHyphenationTree(String key) {
        HyphenationTree hTree = null;
        InputStream ois = null;
        InputStream is = null;
        try {
            block10: {
                block11: {
                    is = Hyphenator.getResourceStream(key);
                    if (is != null) break block10;
                    if (key.length() != 5) break block11;
                    String lang = key.substring(0, 2);
                    is = Hyphenator.getResourceStream(lang);
                    if (is != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Couldn't find hyphenation pattern '" + key + "'. Using general language pattern '" + lang + "' instead.");
                        }
                        break block10;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("Couldn't find precompiled hyphenation pattern " + lang + " in resources.");
                        }
                        HyphenationTree hyphenationTree = null;
                        return hyphenationTree;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug("Couldn't find precompiled hyphenation pattern " + key + " in resources");
                }
                HyphenationTree hyphenationTree = null;
                return hyphenationTree;
            }
            hTree = Hyphenator.readHyphenationTree(is);
            return hTree;
        }
        finally {
            IOUtils.closeQuietly(ois);
        }
    }

    public static HyphenationTree getUserHyphenationTree(String key, String hyphenDir) {
        final File baseDir = new File(hyphenDir);
        HyphenationTreeResolver resolver = new HyphenationTreeResolver(){

            public Source resolve(String href) {
                File f = new File(baseDir, href);
                return new StreamSource(f);
            }
        };
        return Hyphenator.getUserHyphenationTree(key, resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HyphenationTree getUserHyphenationTree(String key, HyphenationTreeResolver resolver) {
        Source source;
        String name;
        HyphenationTree hTree;
        block24: {
            hTree = null;
            name = key + ".hyp";
            source = resolver.resolve(name);
            if (source != null) {
                try {
                    InputStream in = null;
                    if (source instanceof StreamSource) {
                        in = ((StreamSource)source).getInputStream();
                    }
                    if (in != null || source.getSystemId() == null) {
                        throw new UnsupportedOperationException("Cannot load hyphenation pattern file with the supplied Source object: " + source);
                    }
                    in = new URL(source.getSystemId()).openStream();
                    in = new BufferedInputStream(in);
                    try {
                        hTree = Hyphenator.readHyphenationTree(in);
                    }
                    finally {
                        IOUtils.closeQuietly(in);
                    }
                    return hTree;
                }
                catch (IOException ioe) {
                    if (!log.isDebugEnabled()) break block24;
                    log.debug("I/O problem while trying to load " + name, ioe);
                }
            }
        }
        if ((source = resolver.resolve(name = key + ".xml")) != null) {
            hTree = new HyphenationTree();
            try {
                InputStream in = null;
                if (source instanceof StreamSource) {
                    in = ((StreamSource)source).getInputStream();
                }
                if (in == null) {
                    if (source.getSystemId() != null) {
                        in = new URL(source.getSystemId()).openStream();
                    } else {
                        throw new UnsupportedOperationException("Cannot load hyphenation pattern file with the supplied Source object: " + source);
                    }
                }
                if (!(in instanceof BufferedInputStream)) {
                    in = new BufferedInputStream(in);
                }
                try {
                    InputSource src = new InputSource(in);
                    src.setSystemId(source.getSystemId());
                    hTree.loadPatterns(src);
                }
                finally {
                    IOUtils.closeQuietly(in);
                }
                if (statisticsDump) {
                    System.out.println("Stats: ");
                    hTree.printStats();
                }
                return hTree;
            }
            catch (HyphenationException ex) {
                log.error("Can't load user patterns from XML file " + source.getSystemId() + ": " + ex.getMessage());
                return null;
            }
            catch (IOException ioe) {
                if (log.isDebugEnabled()) {
                    log.debug("I/O problem while trying to load " + name, ioe);
                }
                return null;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Could not load user hyphenation file for '" + key + "'.");
        }
        return null;
    }

    public static Hyphenation hyphenate(String lang, String country, HyphenationTreeResolver resolver, String word, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country, resolver);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, String word, int leftMin, int rightMin) {
        return Hyphenator.hyphenate(lang, country, null, word, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, HyphenationTreeResolver resolver, char[] word, int offset, int len, int leftMin, int rightMin) {
        HyphenationTree hTree = Hyphenator.getHyphenationTree(lang, country, resolver);
        if (hTree == null) {
            return null;
        }
        return hTree.hyphenate(word, offset, len, leftMin, rightMin);
    }

    public static Hyphenation hyphenate(String lang, String country, char[] word, int offset, int len, int leftMin, int rightMin) {
        return Hyphenator.hyphenate(lang, country, null, word, offset, len, leftMin, rightMin);
    }

    public void setMinRemainCharCount(int min) {
        this.remainCharCount = min;
    }

    public void setMinPushCharCount(int min) {
        this.pushCharCount = min;
    }

    public void setLanguage(String lang, String country) {
        this.hyphenTree = Hyphenator.getHyphenationTree(lang, country);
    }

    public Hyphenation hyphenate(char[] word, int offset, int len) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, offset, len, this.remainCharCount, this.pushCharCount);
    }

    public Hyphenation hyphenate(String word) {
        if (this.hyphenTree == null) {
            return null;
        }
        return this.hyphenTree.hyphenate(word, this.remainCharCount, this.pushCharCount);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

