/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.properties;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.expr.PropertyException;
import org.apache.fop.fo.flow.TableBody;
import org.apache.fop.fo.flow.TableFObj;
import org.apache.fop.fo.properties.NumberProperty;
import org.apache.fop.fo.properties.Property;
import org.xml.sax.Locator;

public class ColumnNumberPropertyMaker
extends NumberProperty.Maker {
    static /* synthetic */ Class class$org$apache$fop$fo$flow$TableFObj;

    public ColumnNumberPropertyMaker(int propId) {
        super(propId);
    }

    public Property make(PropertyList propertyList) throws PropertyException {
        TableBody parent;
        FObj fo = propertyList.getFObj();
        if (!(fo.getNameId() != 50 && fo.getNameId() != 51 || fo.getNameId() != 50 || fo.getParent().getNameId() == 54 || propertyList.get(213).getEnum() != 149 || (parent = (TableBody)fo.getParent()).previousCellEndedRow())) {
            parent.resetColumnIndex();
        }
        return NumberProperty.getInstance(((TableFObj)fo.getParent()).getCurrentColumnIndex());
    }

    public Property make(PropertyList propertyList, String value, FObj fo) throws PropertyException {
        Property p = super.make(propertyList, value, fo);
        TableFObj parent = (TableFObj)propertyList.getParentFObj();
        int columnIndex = p.getNumeric().getValue();
        if (columnIndex <= 0) {
            Log log = LogFactory.getLog(class$org$apache$fop$fo$flow$TableFObj == null ? (class$org$apache$fop$fo$flow$TableFObj = ColumnNumberPropertyMaker.class$("org.apache.fop.fo.flow.TableFObj")) : class$org$apache$fop$fo$flow$TableFObj);
            log.warn("Specified negative or zero value for column-number on " + fo.getName() + ": " + columnIndex + " forced to " + parent.getCurrentColumnIndex());
            return NumberProperty.getInstance(parent.getCurrentColumnIndex());
        }
        double tmpIndex = p.getNumeric().getNumericValue();
        if (tmpIndex - (double)columnIndex > 0.0) {
            columnIndex = (int)Math.round(tmpIndex);
            Log log = LogFactory.getLog(class$org$apache$fop$fo$flow$TableFObj == null ? (class$org$apache$fop$fo$flow$TableFObj = ColumnNumberPropertyMaker.class$("org.apache.fop.fo.flow.TableFObj")) : class$org$apache$fop$fo$flow$TableFObj);
            log.warn("Rounding specified column-number of " + tmpIndex + " to " + columnIndex);
            p = NumberProperty.getInstance(columnIndex);
        }
        parent.setCurrentColumnIndex(columnIndex);
        int colSpan = propertyList.get(149).getNumeric().getValue();
        int i = -1;
        while (++i < colSpan) {
            if (!parent.isColumnNumberUsed(columnIndex + i)) continue;
            StringBuffer errorMessage = new StringBuffer();
            errorMessage.append(fo.getName() + " overlaps in column ").append(columnIndex + i);
            Locator loc = fo.getLocator();
            if (loc != null && loc.getLineNumber() != -1) {
                errorMessage.append(" (line #").append(loc.getLineNumber()).append(", column #").append(loc.getColumnNumber()).append(")");
            }
            throw new PropertyException(errorMessage.toString());
        }
        return p;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

