/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import org.apache.fop.apps.FOPException;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FONode;
import org.apache.fop.fo.FOText;
import org.apache.fop.fo.FObj;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.RecursiveCharIterator;
import org.apache.fop.fo.flow.Block;
import org.xml.sax.Locator;

public abstract class FObjMixed
extends FObj {
    protected FOText ft = null;
    protected FONode currentTextNode;
    protected FOText lastFOTextProcessed = null;

    protected FObjMixed(FONode parent) {
        super(parent);
    }

    protected void addCharacters(char[] data, int start, int end, PropertyList pList, Locator locator) throws FOPException {
        if (this.ft == null) {
            this.ft = new FOText(this);
            this.ft.setLocator(locator);
            if (!this.inMarker()) {
                this.ft.bind(pList);
            }
        }
        this.ft.addCharacters(data, start, end, null, null);
    }

    protected void endOfNode() throws FOPException {
        this.flushText();
        if (!this.inMarker() || this.getNameId() == 24) {
            this.getFOEventHandler().whiteSpaceHandler.handleWhiteSpace(this, this.currentTextNode);
        }
        super.endOfNode();
    }

    protected static void handleWhiteSpaceFor(FObjMixed fobj) {
        fobj.getFOEventHandler().getXMLWhiteSpaceHandler().handleWhiteSpace(fobj, fobj.currentTextNode);
    }

    protected void flushText() throws FOPException {
        if (this.ft != null) {
            FOText lft = this.ft;
            this.ft = null;
            int indexStart = 0;
            int indexEnd = (lft.ca.length > Short.MAX_VALUE ? Short.MAX_VALUE : lft.ca.length) - 1;
            int charCount = 0;
            while (charCount < lft.ca.length) {
                short tmpSize = (short)(indexEnd - indexStart + 1);
                charCount += tmpSize;
                FOText tmpText = (FOText)lft.clone(this, false);
                tmpText.ca = new char[tmpSize];
                tmpText.startIndex = 0;
                tmpText.endIndex = tmpSize;
                System.arraycopy(lft.ca, indexStart, tmpText.ca, 0, indexEnd - indexStart + 1);
                if (this.getNameId() == 3) {
                    tmpText.createBlockPointers((Block)this);
                    this.lastFOTextProcessed = tmpText;
                } else if (this.getNameId() != 24 && this.getNameId() != 55 && this.getNameId() != 59) {
                    FONode fo = this.parent;
                    int foNameId = fo.getNameId();
                    while (foNameId != 3 && foNameId != 24 && foNameId != 55 && foNameId != 59 && foNameId != 32) {
                        fo = fo.getParent();
                        foNameId = fo.getNameId();
                    }
                    if (foNameId == 3) {
                        tmpText.createBlockPointers((Block)fo);
                        ((FObjMixed)fo).lastFOTextProcessed = tmpText;
                    } else if (foNameId == 32) {
                        log.error("Could not create block pointers. FOText w/o Block ancestor.");
                    }
                }
                tmpText.endOfNode();
                this.addChildNode(tmpText);
                indexStart = indexEnd + 1;
                indexEnd = (lft.ca.length - charCount < Short.MAX_VALUE ? lft.ca.length : charCount + Short.MAX_VALUE) - 1;
            }
        }
    }

    protected void addChildNode(FONode child) throws FOPException {
        this.flushText();
        if (!this.inMarker() || this.getNameId() == 24) {
            if (child instanceof FOText || child.getNameId() == 5) {
                if (this.currentTextNode == null) {
                    this.currentTextNode = child;
                }
            } else {
                this.getFOEventHandler().whiteSpaceHandler.handleWhiteSpace(this, this.currentTextNode, child);
                this.currentTextNode = null;
            }
        }
        super.addChildNode(child);
    }

    public CharIterator charIterator() {
        return new RecursiveCharIterator(this);
    }
}

