/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.apps;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.configuration.DefaultConfigurationBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FopFactory;
import org.apache.fop.util.LogUtil;
import org.xml.sax.SAXException;

public class FopFactoryConfigurator {
    public static final boolean DEFAULT_BREAK_INDENT_INHERITANCE = false;
    public static final boolean DEFAULT_STRICT_USERCONFIG_VALIDATION = true;
    public static final boolean DEFAULT_STRICT_FO_VALIDATION = true;
    public static final String DEFAULT_PAGE_WIDTH = "8.26in";
    public static final String DEFAULT_PAGE_HEIGHT = "11in";
    public static final float DEFAULT_SOURCE_RESOLUTION = 72.0f;
    public static final float DEFAULT_TARGET_RESOLUTION = 72.0f;
    public static final boolean DEFAULT_USE_CACHE = true;
    private final Log log = LogFactory.getLog(class$org$apache$fop$apps$FopFactoryConfigurator == null ? (class$org$apache$fop$apps$FopFactoryConfigurator = FopFactoryConfigurator.class$("org.apache.fop.apps.FopFactoryConfigurator")) : class$org$apache$fop$apps$FopFactoryConfigurator);
    private FopFactory factory = null;
    private Configuration cfg = null;
    static /* synthetic */ Class class$org$apache$fop$apps$FopFactoryConfigurator;

    public FopFactoryConfigurator(FopFactory factory) {
        this.factory = factory;
    }

    public void configure(FopFactory factory) throws FOPException {
        Configuration pageConfig;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Initializing FopFactory Configuration");
        }
        if (this.cfg.getChild("strict-configuration", false) != null) {
            try {
                factory.setStrictUserConfigValidation(this.cfg.getChild("strict-configuration").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, false);
            }
        }
        boolean strict = factory.validateUserConfigStrictly();
        if (this.cfg.getChild("strict-validation", false) != null) {
            try {
                factory.setStrictValidation(this.cfg.getChild("strict-validation").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, strict);
            }
        }
        if (this.cfg.getChild("base", false) != null) {
            try {
                factory.setBaseURL(this.cfg.getChild("base").getValue(null));
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if (this.cfg.getChild("font-base", false) != null) {
            try {
                factory.setFontBaseURL(this.cfg.getChild("font-base").getValue(null));
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if (this.cfg.getChild("hyphenation-base", false) != null) {
            try {
                factory.setHyphenBaseURL(this.cfg.getChild("hyphenation-base").getValue(null));
            }
            catch (MalformedURLException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
        if (this.cfg.getChild("source-resolution", false) != null) {
            factory.setSourceResolution(this.cfg.getChild("source-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug("source-resolution set to: " + factory.getSourceResolution() + "dpi (px2mm=" + factory.getSourcePixelUnitToMillimeter() + ")");
            }
        }
        if (this.cfg.getChild("target-resolution", false) != null) {
            factory.setTargetResolution(this.cfg.getChild("target-resolution").getValueAsFloat(72.0f));
            if (this.log.isDebugEnabled()) {
                this.log.debug("target-resolution set to: " + factory.getTargetResolution() + "dpi (px2mm=" + factory.getTargetPixelUnitToMillimeter() + ")");
            }
        }
        if (this.cfg.getChild("break-indent-inheritance", false) != null) {
            try {
                factory.setBreakIndentInheritanceOnReferenceAreaBoundary(this.cfg.getChild("break-indent-inheritance").getValueAsBoolean());
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(this.log, e, strict);
            }
        }
        if ((pageConfig = this.cfg.getChild("default-page-settings")).getAttribute("height", null) != null) {
            factory.setPageHeight(pageConfig.getAttribute("height", DEFAULT_PAGE_HEIGHT));
            if (this.log.isInfoEnabled()) {
                this.log.info("Default page-height set to: " + factory.getPageHeight());
            }
        }
        if (pageConfig.getAttribute("width", null) != null) {
            factory.setPageWidth(pageConfig.getAttribute("width", DEFAULT_PAGE_WIDTH));
            if (this.log.isInfoEnabled()) {
                this.log.info("Default page-width set to: " + factory.getPageWidth());
            }
        }
        if (this.cfg.getChild("use-cache", false) != null) {
            try {
                factory.setUseCache(this.cfg.getChild("use-cache").getValueAsBoolean());
            }
            catch (ConfigurationException mfue) {
                LogUtil.handleException(this.log, mfue, strict);
            }
        }
    }

    public void setUserConfig(File userConfigFile) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.buildFromFile(userConfigFile));
        }
        catch (ConfigurationException e) {
            throw new FOPException(e);
        }
    }

    public void setUserConfig(String uri) throws SAXException, IOException {
        try {
            DefaultConfigurationBuilder cfgBuilder = new DefaultConfigurationBuilder();
            this.setUserConfig(cfgBuilder.build(uri));
        }
        catch (ConfigurationException e) {
            throw new FOPException(e);
        }
    }

    public void setUserConfig(Configuration cfg) throws FOPException {
        this.cfg = cfg;
        this.configure(this.factory);
    }

    public Configuration getUserConfig() {
        return this.cfg;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

