/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.simulator.SMAAResults;
import fi.smaa.jsmaa.simulator.SMAASimulation;
import org.drugis.common.threading.ThreadHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SimulationBuilder<M extends SMAAModel, R extends SMAAResults, T extends SMAASimulation<M>>
implements Runnable {
    protected M model;
    protected static ThreadHandler handler = ThreadHandler.getInstance();

    protected SimulationBuilder(M model) {
        this.model = ((SMAAModel)model).deepCopy();
    }

    @Override
    public synchronized void run() {
        T simul = this.generateSimulation();
        handler.clear();
        SMAAResults results = ((SMAASimulation)simul).getResults();
        this.prepareSimulation(simul, results);
        handler.scheduleTask(((SMAASimulation)simul).getTask());
    }

    protected abstract void prepareSimulation(T var1, R var2);

    protected abstract T generateSimulation();
}

