/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.CardinalCriterion;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import fi.smaa.jsmaa.model.Rank;
import fi.smaa.jsmaa.model.RankSampler;
import fi.smaa.jsmaa.model.SMAAModel;
import java.util.ArrayList;

public class Sampler {
    private SMAAModel m;

    public Sampler(SMAAModel m) {
        this.m = m;
    }

    public void sample(Criterion crit, double[] target) {
        assert (target.length == this.m.getAlternatives().size());
        if (crit instanceof CardinalCriterion) {
            this.sample((CardinalCriterion)crit, target);
        } else if (crit instanceof OrdinalCriterion) {
            this.sample((OrdinalCriterion)crit, target);
        } else {
            throw new IllegalArgumentException("Unknown criterion type");
        }
    }

    private void sample(OrdinalCriterion o, double[] target) {
        ArrayList<Integer> ranks = new ArrayList<Integer>();
        for (int i = 0; i < target.length; ++i) {
            Integer r = ((Rank)this.m.getMeasurement(o, this.m.getAlternatives().get(i))).getRank();
            ranks.add(r);
        }
        RankSampler rs = new RankSampler(ranks);
        double[] w = rs.sampleWeights();
        for (int i = 0; i < w.length; ++i) {
            target[i] = w[i];
        }
    }

    private void sample(CardinalCriterion c, double[] target) {
        for (int i = 0; i < target.length; ++i) {
            CardinalMeasurement meas = (CardinalMeasurement)this.m.getMeasurement(c, this.m.getAlternatives().get(i));
            target[i] = meas.sample();
        }
    }
}

