/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.SMAATRIModel;
import fi.smaa.jsmaa.model.electre.ElectreTri;
import fi.smaa.jsmaa.simulator.IterationException;
import fi.smaa.jsmaa.simulator.SMAASimulation;
import fi.smaa.jsmaa.simulator.SMAATRIResults;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.drugis.common.threading.AbstractIterativeComputation;
import org.drugis.common.threading.IterativeTask;
import org.drugis.common.threading.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAATRISimulation
extends SMAASimulation<SMAATRIModel> {
    private static final int MAX_SAMPLE_TRIES = 1000;
    private SMAATRIResults results;
    private Map<Alternative, Alternative> sortRes;
    private Map<Alternative, Map<OutrankingCriterion, Double>> criteriaMeasurements;
    private Map<Alternative, Map<OutrankingCriterion, Double>> categoryUpperBounds;
    private double lambda;
    private IterativeTask catAccComputation;

    public SMAATRISimulation(SMAATRIModel triModel, int iterations) {
        super(triModel);
        this.results = new SMAATRIResults(((SMAATRIModel)this.model).getAlternatives(), ((SMAATRIModel)this.model).getCategories(), REPORTING_INTERVAL);
        this.catAccComputation = new IterativeTask(new AbstractIterativeComputation(iterations){

            public void doStep() {
                if (SMAATRISimulation.this.getModel().getCategories().size() == 0) {
                    return;
                }
                SMAATRISimulation.this.generateWeights();
                SMAATRISimulation.this.sampleThresholds();
                SMAATRISimulation.this.sampleCriteria();
                SMAATRISimulation.this.sampleCategoryUpperBounds();
                SMAATRISimulation.this.sampleLambda();
                SMAATRISimulation.this.sortAlternatives();
                SMAATRISimulation.this.updateHits();
            }
        }, "CatAcc computation");
        this.catAccComputation.setReportingInterval(REPORTING_INTERVAL);
    }

    @Override
    public Task getTask() {
        return this.catAccComputation;
    }

    protected void sampleThresholds() throws IterationException {
        for (Criterion c : ((SMAATRIModel)this.model).getCriteria()) {
            ((OutrankingCriterion)c).sampleThresholds();
        }
    }

    private void updateHits() {
        Integer[] cats = new Integer[this.getModel().getAlternatives().size()];
        for (int i = 0; i < cats.length; ++i) {
            Alternative alt = this.getModel().getAlternatives().get(i);
            cats[i] = this.getModel().getCategories().indexOf(this.sortRes.get(alt));
        }
        this.results.update(cats);
    }

    @Override
    protected void sampleCriteria() {
        super.sampleCriteria();
        this.criteriaMeasurements = new HashMap<Alternative, Map<OutrankingCriterion, Double>>();
        for (int altIndex = 0; altIndex < this.getModel().getAlternatives().size(); ++altIndex) {
            Alternative a = this.getModel().getAlternatives().get(altIndex);
            HashMap<OutrankingCriterion, Double> m = new HashMap<OutrankingCriterion, Double>();
            for (int critIndex = 0; critIndex < this.getModel().getCriteria().size(); ++critIndex) {
                OutrankingCriterion oc = (OutrankingCriterion)this.getModel().getCriteria().get(critIndex);
                m.put(oc, this.getMeasurements(critIndex)[altIndex]);
            }
            this.criteriaMeasurements.put(a, m);
        }
    }

    private void sortAlternatives() {
        ArrayList<OutrankingCriterion> ocrits = new ArrayList<OutrankingCriterion>();
        for (Criterion c : this.getModel().getCriteria()) {
            ocrits.add((OutrankingCriterion)c);
        }
        ElectreTri tri = new ElectreTri(this.getModel().getAlternatives(), ocrits, this.getModel().getCategories(), this.criteriaMeasurements, this.categoryUpperBounds, this.weights, this.lambda, this.getModel().getRule());
        this.sortRes = tri.compute();
    }

    private void sampleLambda() {
        this.lambda = this.getModel().getLambda().sample();
    }

    private void sampleCategoryUpperBounds() throws IterationException {
        for (int i = 0; i < 1000; ++i) {
            this.categoryUpperBounds = new HashMap<Alternative, Map<OutrankingCriterion, Double>>();
            for (int catIndex = 0; catIndex < this.getModel().getCategories().size() - 1; ++catIndex) {
                Alternative cat = this.getModel().getCategories().get(catIndex);
                HashMap<OutrankingCriterion, Double> m = new HashMap<OutrankingCriterion, Double>();
                for (int critIndex = 0; critIndex < this.getModel().getCriteria().size(); ++critIndex) {
                    OutrankingCriterion oc = (OutrankingCriterion)this.getModel().getCriteria().get(critIndex);
                    m.put(oc, this.getModel().getCategoryUpperBound(oc, cat).sample());
                }
                this.categoryUpperBounds.put(cat, m);
            }
            if (this.checkCategoryUpperBounds()) break;
            if (i != 999) continue;
            throw new IterationException("Cannot sample category upper bounds, dominance not satisfied");
        }
    }

    private SMAATRIModel getModel() {
        return (SMAATRIModel)this.model;
    }

    private boolean checkCategoryUpperBounds() {
        for (Criterion c : this.getModel().getCriteria()) {
            OutrankingCriterion oc = (OutrankingCriterion)c;
            Double compareVal = oc.getAscending() != false ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            for (int catIndex = 0; catIndex < this.getModel().getCategories().size() - 1; ++catIndex) {
                Alternative cat = this.getModel().getCategories().get(catIndex);
                Double bound = this.categoryUpperBounds.get(cat).get(oc);
                if (oc.getAscending() != false ? bound < compareVal : bound > compareVal) {
                    return false;
                }
                compareVal = bound;
            }
        }
        return true;
    }

    @Override
    public SMAATRIResults getResults() {
        return this.results;
    }
}

