/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.simulator.Acceptabilities;
import fi.smaa.jsmaa.simulator.SMAAResults;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAATRIResults
extends SMAAResults {
    private Acceptabilities categoryAcceptabilities;
    private List<Alternative> categories;

    public SMAATRIResults(List<Alternative> alts, List<Alternative> categories, int updateInterval) {
        super(alts, updateInterval);
        this.categories = categories;
        this.reset();
    }

    @Override
    public void reset() {
        this.categoryAcceptabilities = new Acceptabilities(this.alternatives, this.categories.size());
    }

    public void update(Integer[] categories) {
        assert (categories.length == this.alternatives.size());
        for (int altIndex = 0; altIndex < categories.length; ++altIndex) {
            this.categoryAcceptabilities.hit(altIndex, categories[altIndex]);
        }
        if (this.getIteration() % this.updateInterval == 0) {
            this.fireResultsChanged();
        }
    }

    public Integer getIteration() {
        return new Integer(this.categoryAcceptabilities.getTotalHits(0));
    }

    public Map<Alternative, List<Double>> getCategoryAcceptabilities() {
        return this.categoryAcceptabilities.getResults();
    }

    public List<Alternative> getCategories() {
        return this.categories;
    }
}

