/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.BaselineGaussianMeasurement;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.simulator.IterationException;
import fi.smaa.jsmaa.simulator.SMAAResults;
import fi.smaa.jsmaa.simulator.Sampler;
import org.drugis.common.threading.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMAASimulation<M extends SMAAModel> {
    protected double[][] measurements;
    protected M model;
    protected Sampler sampler;
    protected double[] weights;
    public static int REPORTING_INTERVAL = 100;

    public SMAASimulation(M model) {
        this.model = model;
        this.initialize();
    }

    private void initialize() {
        this.measurements = new double[((SMAAModel)this.model).getCriteria().size()][((SMAAModel)this.model).getAlternatives().size()];
        this.sampler = new Sampler((SMAAModel)this.model);
    }

    public abstract SMAAResults getResults();

    public void reset() {
        this.initialize();
    }

    protected void sampleCriteria() {
        this.updateBaselines();
        for (int i = 0; i < ((SMAAModel)this.model).getCriteria().size(); ++i) {
            this.sampler.sample(((SMAAModel)this.model).getCriteria().get(i), this.measurements[i]);
        }
    }

    private void updateBaselines() {
        for (Criterion c : ((SMAAModel)this.model).getCriteria()) {
            BaselineGaussianMeasurement baseline = ((SMAAModel)this.model).getImpactMatrix().getBaseline(c);
            if (baseline == null) continue;
            baseline.update();
        }
    }

    protected double[] getMeasurements(int critIndex) {
        assert (critIndex >= 0 && critIndex < this.measurements.length);
        return this.measurements[critIndex];
    }

    protected void generateWeights() throws IterationException {
        this.weights = ((SMAAModel)this.model).getPreferenceInformation().sampleWeights();
        if (this.weights.length != ((SMAAModel)this.model).getCriteria().size()) {
            this.weights = new double[((SMAAModel)this.model).getCriteria().size()];
        }
    }

    public abstract Task getTask();
}

