/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.simulator.IterationException;
import fi.smaa.jsmaa.simulator.ResultsEvent;
import fi.smaa.jsmaa.simulator.SMAAResultsListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SMAAResults {
    protected ConcurrentLinkedQueue<SMAAResultsListener> listeners = new ConcurrentLinkedQueue();
    protected List<Alternative> alternatives;
    protected int updateInterval;

    protected SMAAResults(List<Alternative> alts, int updateInterval) {
        this.alternatives = alts;
        this.updateInterval = updateInterval;
    }

    public abstract void reset();

    public void addResultsListener(SMAAResultsListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeResultsListener(SMAAResultsListener listener) {
        this.listeners.remove(listener);
    }

    protected void fireResultsChanged() {
        for (SMAAResultsListener listener : this.listeners) {
            listener.resultsChanged(new ResultsEvent(this));
        }
    }

    public List<Alternative> getAlternatives() {
        return this.alternatives;
    }

    protected Map<Alternative, List<Double>> transformMap(Map<Integer, List<Double>> map) {
        HashMap<Alternative, List<Double>> cw = new HashMap<Alternative, List<Double>>();
        for (Integer index : map.keySet()) {
            cw.put(this.alternatives.get(index), map.get(index));
        }
        return cw;
    }

    protected void fireResultsChanged(IterationException e) {
        for (SMAAResultsListener listener : this.listeners) {
            listener.resultsChanged(new ResultsEvent(this, e));
        }
    }
}

