/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.ScaleCriterion;
import fi.smaa.jsmaa.model.maut.UtilIndexPair;
import fi.smaa.jsmaa.model.maut.UtilityFunction;
import fi.smaa.jsmaa.simulator.SMAA2Results;
import fi.smaa.jsmaa.simulator.SMAASimulation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.drugis.common.threading.AbstractIterativeComputation;
import org.drugis.common.threading.IterativeTask;
import org.drugis.common.threading.Task;
import org.drugis.common.threading.activity.ActivityModel;
import org.drugis.common.threading.activity.ActivityTask;
import org.drugis.common.threading.activity.DirectTransition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAA2Simulation
extends SMAASimulation<SMAAModel> {
    private SMAA2Results results;
    private boolean[] confidenceHits;
    private double[] utilities;
    private Integer[] ranks;
    private IterativeTask rankAccComputation;
    private IterativeTask confFacComputation;
    private ActivityTask activityTask;

    public SMAA2Simulation(SMAAModel amodel, int iterations) {
        super(amodel);
        this.results = new SMAA2Results(this.model.getAlternatives(), this.model.getCriteria(), REPORTING_INTERVAL);
        this.reset();
        this.rankAccComputation = new IterativeTask(new AbstractIterativeComputation(iterations){

            public void doStep() {
                SMAA2Simulation.this.generateWeights();
                SMAA2Simulation.this.sampleCriteria();
                SMAA2Simulation.this.aggregate();
                SMAA2Simulation.this.rankAlternatives();
                SMAA2Simulation.this.results.update(SMAA2Simulation.this.ranks, SMAA2Simulation.this.weights);
            }
        }, "RA & CW computation");
        this.rankAccComputation.setReportingInterval(REPORTING_INTERVAL);
        this.confFacComputation = new IterativeTask(new AbstractIterativeComputation(iterations){

            public void doStep() {
                SMAA2Simulation.this.sampleCriteria();
                SMAA2Simulation.this.aggregateWithCentralWeights();
                SMAA2Simulation.this.results.confidenceUpdate(SMAA2Simulation.this.confidenceHits);
            }
        }, "CF computation");
        this.confFacComputation.setReportingInterval(REPORTING_INTERVAL);
        ArrayList<DirectTransition> transitions = new ArrayList<DirectTransition>();
        transitions.add(new DirectTransition(this.rankAccComputation, this.confFacComputation));
        this.activityTask = new ActivityTask(new ActivityModel(this.rankAccComputation, this.confFacComputation, transitions), "SMAA-2");
    }

    @Override
    public SMAA2Results getResults() {
        return this.results;
    }

    private void rankAlternatives() {
        Object[] pairs = new UtilIndexPair[this.utilities.length];
        for (int i = 0; i < this.utilities.length; ++i) {
            pairs[i] = new UtilIndexPair(i, this.utilities[i]);
        }
        Arrays.sort(pairs);
        int rank = 0;
        Double oldUtility = pairs.length > 0 ? ((UtilIndexPair)pairs[0]).util : 0.0;
        for (int i = 0; i < pairs.length; ++i) {
            if (!oldUtility.equals(((UtilIndexPair)pairs[i]).util)) {
                ++rank;
                oldUtility = ((UtilIndexPair)pairs[i]).util;
            }
            this.ranks[((UtilIndexPair)pairs[i]).altIndex] = rank;
        }
    }

    private void aggregate() {
        this.clearUtilities();
        for (int critIndex = 0; critIndex < this.model.getCriteria().size(); ++critIndex) {
            Criterion crit = this.model.getCriteria().get(critIndex);
            int altIndex = 0;
            while (altIndex < this.model.getAlternatives().size()) {
                double partUtil = this.computePartialUtility(critIndex, crit, altIndex);
                int n = altIndex++;
                this.utilities[n] = this.utilities[n] + this.weights[critIndex] * partUtil;
            }
        }
    }

    private void aggregateWithCentralWeights() {
        this.clearConfidenceHits();
        Map<Alternative, Map<Criterion, Double>> cws = this.results.getCentralWeightVectors();
        block0: for (int altIndex = 0; altIndex < this.model.getAlternatives().size(); ++altIndex) {
            Map<Criterion, Double> cw = cws.get(this.model.getAlternatives().get(altIndex));
            double utility = this.computeUtility(altIndex, cw);
            for (int otherAlt = 0; otherAlt < this.model.getAlternatives().size(); ++otherAlt) {
                double otherUtility;
                if (altIndex == otherAlt || !((otherUtility = this.computeUtility(otherAlt, cw)) > utility)) continue;
                this.confidenceHits[altIndex] = false;
                continue block0;
            }
        }
    }

    private void clearConfidenceHits() {
        for (int i = 0; i < this.confidenceHits.length; ++i) {
            this.confidenceHits[i] = true;
        }
    }

    private double computeUtility(int altIndex, Map<Criterion, Double> cw) {
        double utility = 0.0;
        for (int i = 0; i < this.model.getCriteria().size(); ++i) {
            double partUtil = this.computePartialUtility(i, this.model.getCriteria().get(i), altIndex);
            utility += partUtil * cw.get(this.model.getCriteria().get(i));
        }
        return utility;
    }

    private double computePartialUtility(int critIndex, Criterion crit, int altIndex) {
        if (crit instanceof ScaleCriterion) {
            return UtilityFunction.utility((ScaleCriterion)crit, this.measurements[critIndex][altIndex]);
        }
        if (crit instanceof OrdinalCriterion) {
            return this.measurements[critIndex][altIndex];
        }
        throw new RuntimeException("Unknown criterion type");
    }

    private void clearUtilities() {
        Arrays.fill(this.utilities, 0.0);
    }

    @Override
    public void reset() {
        super.reset();
        this.results.reset();
        int numAlts = this.model.getAlternatives().size();
        this.utilities = new double[numAlts];
        this.ranks = new Integer[numAlts];
        this.confidenceHits = new boolean[numAlts];
    }

    @Override
    public Task getTask() {
        return this.activityTask;
    }
}

