/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.simulator.Acceptabilities;
import fi.smaa.jsmaa.simulator.SMAAResults;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAA2Results
extends SMAAResults {
    private double[][] centralWeightAdds;
    private Map<Integer, List<Double>> centralWeightVectors;
    private static final int FIRSTRANK = 0;
    private int[] confidenceHits;
    private int confidenceIteration;
    private List<Double> confidenceFactors;
    private Acceptabilities rankAcceptabilities;
    private List<? extends Criterion> criteria;

    public SMAA2Results(List<Alternative> alternatives, List<? extends Criterion> criteria, int updateInterval) {
        super(alternatives, updateInterval);
        this.criteria = criteria;
        this.reset();
    }

    public void update(Integer[] ranks, double[] weights) {
        assert (ranks.length == this.rankAcceptabilities.getLength());
        assert (weights.length == this.centralWeightAdds[0].length);
        for (int altIndex = 0; altIndex < ranks.length; ++altIndex) {
            this.rankAcceptabilities.hit(altIndex, ranks[altIndex]);
            if (ranks[altIndex] != 0) continue;
            this.addCentralWeight(altIndex, weights);
        }
        if (this.getRankAccIteration() % this.updateInterval == 0) {
            this.calculateRankAccsAndCentralWeights();
            this.fireResultsChanged();
        }
    }

    public void confidenceUpdate(boolean[] hit) {
        assert (hit.length == this.confidenceHits.length);
        ++this.confidenceIteration;
        for (int i = 0; i < hit.length; ++i) {
            if (!hit[i]) continue;
            int n = i;
            this.confidenceHits[n] = this.confidenceHits[n] + 1;
        }
        if (this.confidenceIteration % this.updateInterval == 0) {
            this.calculateConfidenceFactors();
            this.fireResultsChanged();
        }
    }

    private void calculateConfidenceFactors() {
        for (int i = 0; i < this.confidenceFactors.size(); ++i) {
            this.confidenceFactors.set(i, this.calculateConfidenceFactor(i));
        }
    }

    private Double calculateConfidenceFactor(int altIndex) {
        return (double)this.confidenceHits[altIndex] / (double)this.confidenceIteration;
    }

    public Integer getRankAccIteration() {
        return new Integer(this.rankAcceptabilities.getTotalHits(0));
    }

    public Map<Alternative, Map<Criterion, Double>> getCentralWeightVectors() {
        HashMap<Alternative, Map<Criterion, Double>> cw = new HashMap<Alternative, Map<Criterion, Double>>();
        for (Integer index : this.centralWeightVectors.keySet()) {
            HashMap<Criterion, Double> vector = new HashMap<Criterion, Double>();
            for (int i = 0; i < this.criteria.size(); ++i) {
                vector.put(this.criteria.get(i), this.centralWeightVectors.get(index).get(i));
            }
            cw.put((Alternative)this.alternatives.get(index), (Map<Criterion, Double>)vector);
        }
        return cw;
    }

    public Map<Alternative, Double> getConfidenceFactors() {
        HashMap<Alternative, Double> confs = new HashMap<Alternative, Double>();
        for (int i = 0; i < this.confidenceFactors.size(); ++i) {
            confs.put((Alternative)this.alternatives.get(i), this.confidenceFactors.get(i));
        }
        return confs;
    }

    public Map<Alternative, List<Double>> getRankAcceptabilities() {
        return this.rankAcceptabilities.getResults();
    }

    public List<? extends Criterion> getCriteria() {
        return this.criteria;
    }

    private void initializeCentralWeightVectors() {
        this.centralWeightVectors = this.createAlternativeMapWithNans(this.criteria.size());
    }

    private void initializeRankAcceptabilities() {
        this.rankAcceptabilities = new Acceptabilities(this.alternatives, this.alternatives.size());
    }

    private void initializeConfidenceFactors() {
        this.confidenceFactors = new ArrayList<Double>();
        for (int i = 0; i < this.alternatives.size(); ++i) {
            this.confidenceFactors.add(Double.NaN);
        }
    }

    private HashMap<Integer, List<Double>> createAlternativeMapWithNans(int size) {
        Object[] vals = new Double[size];
        Arrays.fill(vals, (Object)Double.NaN);
        HashMap<Integer, List<Double>> map = new HashMap<Integer, List<Double>>();
        for (int index = 0; index < this.alternatives.size(); ++index) {
            ArrayList<Object> vec = new ArrayList<Object>(Arrays.asList(vals));
            map.put(index, vec);
        }
        return map;
    }

    private void addCentralWeight(int altIndex, double[] weights) {
        for (int i = 0; i < weights.length; ++i) {
            double[] dArray = this.centralWeightAdds[altIndex];
            int n = i;
            dArray[n] = dArray[n] + weights[i];
        }
    }

    @Override
    public void reset() {
        int numAlts = this.alternatives.size();
        int numCrit = this.criteria.size();
        this.centralWeightAdds = new double[numAlts][numCrit];
        this.confidenceHits = new int[numAlts];
        this.confidenceIteration = 0;
        this.initializeCentralWeightVectors();
        this.initializeRankAcceptabilities();
        this.initializeConfidenceFactors();
    }

    private void calculateRankAccsAndCentralWeights() {
        this.calculateCentralWeightVectors();
    }

    private void calculateCentralWeightVectors() {
        for (Integer altIndex : this.centralWeightVectors.keySet()) {
            List<Double> vec = this.centralWeightVectors.get(altIndex);
            if (this.rankAcceptabilities.getHits(altIndex, 0) <= 0) continue;
            for (int i = 0; i < vec.size(); ++i) {
                vec.set(i, this.centralWeightAdds[altIndex][i] / (double)this.rankAcceptabilities.getHits(altIndex, 0));
            }
        }
    }
}

