/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResultsMap {
    protected List<Alternative> alternatives;
    protected Map<Integer, List<Double>> results;
    protected int size;

    public ResultsMap(List<Alternative> alternatives, int size) {
        this.alternatives = alternatives;
        this.size = size;
        this.results = ResultsMap.createAlternativeMapWithNans(alternatives, size);
    }

    public Map<Alternative, List<Double>> getResults() {
        this.computeResults();
        return this.transformMap(this.results);
    }

    protected abstract void computeResults();

    private static HashMap<Integer, List<Double>> createAlternativeMapWithNans(List<Alternative> alternatives, int size) {
        Object[] vals = new Double[size];
        Arrays.fill(vals, (Object)Double.NaN);
        HashMap<Integer, List<Double>> map = new HashMap<Integer, List<Double>>();
        for (int index = 0; index < alternatives.size(); ++index) {
            ArrayList<Object> vec = new ArrayList<Object>(Arrays.asList(vals));
            map.put(index, vec);
        }
        return map;
    }

    private Map<Alternative, List<Double>> transformMap(Map<Integer, List<Double>> map) {
        HashMap<Alternative, List<Double>> cw = new HashMap<Alternative, List<Double>>();
        for (Integer index : map.keySet()) {
            cw.put(this.alternatives.get(index), map.get(index));
        }
        return cw;
    }

    public int getLength() {
        return this.size;
    }
}

