/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.simulator;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.simulator.ResultsMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Acceptabilities
extends ResultsMap {
    protected int[][] hits;

    public Acceptabilities(List<Alternative> alternatives, int size) {
        super(alternatives, size);
        this.hits = new int[alternatives.size()][size];
    }

    @Override
    public void computeResults() {
        this.calculateAcceptabilities();
    }

    private void calculateAcceptabilities() {
        for (Integer altIndex : this.results.keySet()) {
            List vec = (List)this.results.get(altIndex);
            for (int i = 0; i < vec.size(); ++i) {
                vec.set(i, this.calculateAcceptability(altIndex, i));
            }
        }
    }

    private double calculateAcceptability(Integer altIndex, int rank) {
        int totalIter = 0;
        for (int i = 0; i < this.hits[altIndex].length; ++i) {
            totalIter += this.hits[altIndex][i];
        }
        return (double)this.hits[altIndex][rank] / (double)totalIter;
    }

    public void hit(int altIndex, int resIndex) {
        int[] nArray = this.hits[altIndex];
        int n = resIndex;
        nArray[n] = nArray[n] + 1;
    }

    public int getTotalHits(int altIndex) {
        int total = 0;
        if (this.hits.length < 1) {
            return 0;
        }
        for (int i = 0; i < this.hits[0].length; ++i) {
            total += this.hits[0][i];
        }
        return total;
    }

    public int getHits(int altIndex, int resIndex) {
        return this.hits[altIndex][resIndex];
    }
}

