/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model.electre;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.electre.OutrankingFunction;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElectreTri {
    private List<Alternative> alts;
    private List<OutrankingCriterion> crit;
    private Map<Alternative, Map<OutrankingCriterion, Double>> measurements;
    private Map<Alternative, Map<OutrankingCriterion, Double>> categoryUpperBounds;
    private boolean optimistic;
    private double lambda;
    private double[] weights;
    private List<Alternative> categories;

    public ElectreTri(List<Alternative> alts, List<OutrankingCriterion> crit, List<Alternative> categories, Map<Alternative, Map<OutrankingCriterion, Double>> measurements, Map<Alternative, Map<OutrankingCriterion, Double>> categoryUpperBounds, double[] weights, double lambda, boolean optimistic) {
        assert (weights.length == crit.size());
        this.measurements = measurements;
        this.categoryUpperBounds = categoryUpperBounds;
        this.lambda = lambda;
        this.optimistic = optimistic;
        this.weights = weights;
        this.categories = categories;
        this.alts = alts;
        this.crit = crit;
    }

    public Map<Alternative, Alternative> compute() {
        HashMap<Alternative, Alternative> resMap = new HashMap<Alternative, Alternative>();
        if (this.categories.size() == 1) {
            for (Alternative a : this.alts) {
                resMap.put(a, this.categories.get(0));
            }
            return resMap;
        }
        block1: for (Alternative a : this.alts) {
            Alternative cat;
            int i;
            if (this.optimistic) {
                for (i = this.categories.size() - 2; i >= 0; --i) {
                    cat = this.categories.get(i);
                    if (!this.preferred(this.categoryUpperBounds.get(cat), this.measurements.get(a))) {
                        resMap.put(a, this.categories.get(i + 1));
                        continue block1;
                    }
                    if (i != 0) continue;
                    resMap.put(a, cat);
                }
                continue;
            }
            for (i = 0; i < this.categories.size() - 1; ++i) {
                cat = this.categories.get(i);
                if (!this.outranks(this.measurements.get(a), this.categoryUpperBounds.get(cat))) {
                    resMap.put(a, this.categories.get(i));
                    continue block1;
                }
                if (i != this.categories.size() - 2) continue;
                resMap.put(a, cat);
            }
        }
        return resMap;
    }

    public boolean outranks(Map<OutrankingCriterion, Double> alt, Map<OutrankingCriterion, Double> toAlt) {
        assert (alt.entrySet().size() == toAlt.entrySet().size());
        assert (alt.entrySet().size() == this.weights.length);
        double concordance = this.concordance(alt, toAlt);
        return concordance >= this.lambda;
    }

    public double concordance(Map<OutrankingCriterion, Double> alt, Map<OutrankingCriterion, Double> toAlt) {
        double concordance = 0.0;
        for (int i = 0; i < this.crit.size(); ++i) {
            OutrankingCriterion c = this.crit.get(i);
            Double altVal = alt.get(c);
            Double toAltVal = toAlt.get(c);
            concordance += OutrankingFunction.concordance(c, altVal, toAltVal) * this.weights[i];
        }
        return concordance;
    }

    public boolean preferred(Map<OutrankingCriterion, Double> alt, Map<OutrankingCriterion, Double> toAlt) {
        assert (alt.entrySet().size() == toAlt.entrySet().size());
        assert (alt.entrySet().size() == this.weights.length);
        return this.outranks(alt, toAlt) && !this.outranks(toAlt, alt);
    }

    public void setRule(boolean optimistic) {
        this.optimistic = optimistic;
    }
}

