/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ImpactMatrix;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.Measurement;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.SMAAModel;
import fi.smaa.jsmaa.model.xml.AlternativeList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAATRIModel
extends SMAAModel {
    private static final long serialVersionUID = -739020656344899318L;
    private ImpactMatrix profileMatrix;
    private List<Alternative> categories = new ArrayList<Alternative>();
    private boolean optimistic = true;
    private Interval lambda;
    public static final String PROPERTY_RULE = "rule";
    public static final String PROPERTY_LAMBDA = "lambda";
    private static final XMLFormat<SMAATRIModel> XML = new XMLFormat<SMAATRIModel>(SMAATRIModel.class){

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public SMAATRIModel newInstance(Class<SMAATRIModel> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new SMAATRIModel(ie.getAttribute("name").toString());
        }

        @Override
        public void read(XMLFormat.InputElement ie, SMAATRIModel model) throws XMLStreamException {
            model.optimistic = ie.getAttribute("optimisticRule").toBoolean();
            SMAAModel.XML.read(ie, model);
            Interval nival = ie.get(SMAATRIModel.PROPERTY_LAMBDA, Interval.class);
            model.lambda.setEnd(1.0);
            model.lambda.setStart(nival.getStart());
            model.lambda.setEnd(nival.getEnd());
            AlternativeList categories = ie.get("categories", AlternativeList.class);
            for (Alternative a : categories.getList()) {
                model.addCategory(a);
            }
            ImpactMatrix im = ie.get("upperBounds", ImpactMatrix.class);
            model.profileMatrix = im;
            model.profileMatrix.addListener(model.impactListener);
        }

        @Override
        public void write(SMAATRIModel model, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.setAttribute("optimisticRule", model.getRule());
            SMAAModel.XML.write(model, oe);
            oe.add(model.lambda, SMAATRIModel.PROPERTY_LAMBDA, Interval.class);
            oe.add(new AlternativeList(model.categories), "categories", AlternativeList.class);
            oe.add(model.profileMatrix, "upperBounds", ImpactMatrix.class);
        }
    };

    public SMAATRIModel(String name) {
        super(name);
        this.profileMatrix = new ImpactMatrix();
        this.lambda = new Interval(0.65, 0.85);
        this.profileMatrix.addListener(this.impactListener);
        this.lambda.addPropertyChangeListener(new LambdaListener());
    }

    public void setRule(boolean optimistic) {
        this.optimistic = optimistic;
        this.fireModelChange(8);
    }

    public Interval getLambda() {
        return this.lambda;
    }

    public boolean getRule() {
        return this.optimistic;
    }

    public synchronized void addCategory(Alternative cat) {
        this.categories.add(cat);
        if (this.categories.size() > 1) {
            this.profileMatrix.addAlternative(this.categories.get(this.categories.size() - 2));
        }
        this.fireModelChange(7);
    }

    public synchronized void deleteCategory(Alternative cat) {
        if (this.categories.remove(cat)) {
            this.profileMatrix.deleteAlternative(cat);
            this.fireModelChange(7);
        }
    }

    public List<Alternative> getCategories() {
        return this.categories;
    }

    @Override
    public synchronized void addCriterion(Criterion c) {
        if (!(c instanceof OutrankingCriterion)) {
            throw new IllegalArgumentException("All criteria should be outranking-criteria");
        }
        this.profileMatrix.addCriterion(c);
        super.addCriterion(c);
    }

    @Override
    public synchronized void deleteCriterion(Criterion c) {
        this.profileMatrix.deleteCriterion(c);
        super.deleteCriterion(c);
    }

    @Override
    public void setMeasurement(Criterion crit, Alternative alt, Measurement meas) {
        if (this.profileMatrix.getAlternatives().contains(alt)) {
            this.setCategoryUpperBound((OutrankingCriterion)crit, alt, (CardinalMeasurement)meas);
        } else {
            super.setMeasurement(crit, alt, meas);
        }
    }

    @Override
    public CardinalMeasurement getMeasurement(Criterion crit, Alternative alt) {
        if (this.profileMatrix.getAlternatives().contains(alt)) {
            return this.getCategoryUpperBound((OutrankingCriterion)crit, alt);
        }
        return (CardinalMeasurement)super.getMeasurement(crit, alt);
    }

    public void setCategoryUpperBound(OutrankingCriterion crit, Alternative category, CardinalMeasurement meas) {
        this.profileMatrix.setMeasurement(crit, category, meas);
    }

    public CardinalMeasurement getCategoryUpperBound(OutrankingCriterion crit, Alternative category) {
        return (CardinalMeasurement)this.profileMatrix.getMeasurement(crit, category);
    }

    private void readObject(ObjectInputStream i) throws IOException, ClassNotFoundException {
        i.defaultReadObject();
        this.profileMatrix.addListener(this.impactListener);
        this.lambda.addPropertyChangeListener(new LambdaListener());
    }

    @Override
    public synchronized SMAATRIModel deepCopy() {
        SMAATRIModel model = new SMAATRIModel(this.getName());
        super.deepCopyContents(model);
        ArrayList<Alternative> cats = new ArrayList<Alternative>();
        for (Alternative cat : this.categories) {
            cats.add(cat.deepCopy());
        }
        model.categories = cats;
        ArrayList<Alternative> catsMinusLastOne = new ArrayList<Alternative>();
        for (int i = 0; i < model.categories.size() - 1; ++i) {
            catsMinusLastOne.add(model.categories.get(i));
        }
        model.profileMatrix = this.profileMatrix.deepCopy(catsMinusLastOne, model.getCriteria());
        model.setRule(this.optimistic);
        model.getLambda().setStart(this.getLambda().getStart());
        model.getLambda().setEnd(this.getLambda().getEnd());
        return model;
    }

    public void reorderCategories(List<Alternative> newCats) {
        assert (newCats.size() == this.categories.size());
        if (this.categories.size() == 0) {
            return;
        }
        Alternative oldLastCat = this.categories.get(this.categories.size() - 1);
        Alternative newLastCat = newCats.get(newCats.size() - 1);
        this.categories = newCats;
        if (newLastCat != oldLastCat) {
            this.profileMatrix.deleteAlternative(newLastCat);
            this.profileMatrix.addAlternative(oldLastCat);
        }
        ArrayList<Alternative> catList = new ArrayList<Alternative>(newCats);
        catList.remove(newCats.get(newCats.size() - 1));
        this.profileMatrix.reorderAlternatives(catList);
        this.fireModelChange(7);
    }

    @Override
    public void reorderCriteria(List<Criterion> newCrit) {
        this.profileMatrix.reorderCriteria(newCrit);
        super.reorderCriteria(newCrit);
    }

    public ImpactMatrix getProfileImpactMatrix() {
        return this.profileMatrix;
    }

    private class LambdaListener
    implements PropertyChangeListener {
        private LambdaListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            SMAATRIModel.this.fireModelChange(8);
        }
    }
}

