/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.AbstractEntity;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ImpactMatrix;
import fi.smaa.jsmaa.model.ImpactMatrixListener;
import fi.smaa.jsmaa.model.Measurement;
import fi.smaa.jsmaa.model.MissingPreferenceInformation;
import fi.smaa.jsmaa.model.ModelChangeEvent;
import fi.smaa.jsmaa.model.PreferenceInformation;
import fi.smaa.jsmaa.model.SMAAModelListener;
import fi.smaa.jsmaa.model.xml.AlternativeList;
import fi.smaa.jsmaa.model.xml.CriterionList;
import fi.smaa.jsmaa.model.xml.InvalidModelVersionException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SMAAModel
extends AbstractEntity {
    public static final int MODELVERSION = 2;
    public static final String PROPERTY_NAME = "name";
    private String name;
    protected PreferenceInformation preferences;
    protected ImpactMatrix impactMatrix;
    private static final long serialVersionUID = 6100076809211865658L;
    private List<Alternative> alternatives = new ArrayList<Alternative>();
    private List<Criterion> criteria = new ArrayList<Criterion>();
    private transient List<SMAAModelListener> modelListeners = new ArrayList<SMAAModelListener>();
    protected transient ImpactMatrixListener impactListener = new ImpactListener();
    private transient CriteriaListener critListener = new CriteriaListener();
    protected static final XMLFormat<SMAAModel> XML = new XMLFormat<SMAAModel>(SMAAModel.class){

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public SMAAModel newInstance(Class<SMAAModel> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new SMAAModel(ie.getAttribute(SMAAModel.PROPERTY_NAME).toString());
        }

        @Override
        public void read(XMLFormat.InputElement ie, SMAAModel model) throws XMLStreamException {
            ImpactMatrix im;
            int version = ie.getAttribute("modelVersion", 0);
            if (version > 2) {
                throw new InvalidModelVersionException(version);
            }
            model.setName(ie.getAttribute(SMAAModel.PROPERTY_NAME).toString());
            AlternativeList alternatives = ie.get("alternatives", AlternativeList.class);
            for (Alternative a : alternatives.getList()) {
                model.addAlternative(a);
            }
            CriterionList crits = ie.get("criteria", CriterionList.class);
            for (Criterion c : crits.getList()) {
                model.addCriterion(c);
            }
            model.impactMatrix = im = ie.get("measurements", ImpactMatrix.class);
            model.impactMatrix.addListener(model.impactListener);
            PreferenceInformation pref = (PreferenceInformation)ie.get("preferences");
            if (pref != null) {
                model.setPreferenceInformation(pref);
            }
        }

        @Override
        public void write(SMAAModel model, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.setAttribute(SMAAModel.PROPERTY_NAME, model.getName());
            oe.setAttribute("modelVersion", 2);
            oe.add(new AlternativeList(model.alternatives), "alternatives", AlternativeList.class);
            oe.add(new CriterionList(model.criteria), "criteria", CriterionList.class);
            oe.add(model.impactMatrix, "measurements", ImpactMatrix.class);
            if (!(model.getPreferenceInformation() instanceof MissingPreferenceInformation)) {
                oe.add(model.preferences, "preferences");
            }
        }
    };

    public SMAAModel(String name) {
        this.name = name;
        this.setPreferenceInformation(new MissingPreferenceInformation(0));
        this.impactMatrix = new ImpactMatrix(this.alternatives, this.criteria);
        this.impactMatrix.addListener(this.impactListener);
    }

    public void setPreferenceInformation(PreferenceInformation preferences) {
        this.preferences = preferences;
        preferences.addPropertyChangeListener(new MyPreferenceListener());
        this.fireModelChange(5);
    }

    public void addModelListener(SMAAModelListener l) {
        if (!this.modelListeners.contains(l)) {
            this.modelListeners.add(l);
        }
    }

    public void removeModelListener(SMAAModelListener l) {
        this.modelListeners.remove(l);
    }

    public PreferenceInformation getPreferenceInformation() {
        return this.preferences;
    }

    public List<Alternative> getAlternatives() {
        return this.alternatives;
    }

    public void setName(String name) {
        String oldVal = this.name;
        this.name = name;
        this.firePropertyChange(PROPERTY_NAME, oldVal, name);
    }

    public String getName() {
        return this.name;
    }

    public synchronized void addAlternative(Alternative alt) {
        if (this.alternatives.contains(alt)) {
            return;
        }
        this.alternatives.add(alt);
        this.impactMatrix.removeListener(this.impactListener);
        this.impactMatrix.addAlternative(alt);
        this.impactMatrix.addListener(this.impactListener);
        this.fireModelChange(2);
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    private void connectCriteriaListeners(List<Criterion> newCriteria) {
        for (Criterion c : newCriteria) {
            c.addPropertyChangeListener(this.critListener);
        }
    }

    public synchronized void addCriterion(Criterion crit) {
        this.criteria.add(crit);
        this.impactMatrix.removeListener(this.impactListener);
        this.impactMatrix.addCriterion(crit);
        this.impactMatrix.addListener(this.impactListener);
        this.preferences = new MissingPreferenceInformation(this.getCriteria().size());
        crit.addPropertyChangeListener(this.critListener);
        this.fireModelChange(1);
    }

    public void setMeasurement(Criterion crit, Alternative alt, Measurement meas) {
        this.impactMatrix.setMeasurement(crit, alt, meas);
    }

    public Measurement getMeasurement(Criterion crit, Alternative alt) {
        return this.impactMatrix.getMeasurement(crit, alt);
    }

    public String toString() {
        return this.name;
    }

    public String toStringDeep() {
        String ret = this.name + " : " + this.alternatives.size() + " alternatives - " + this.criteria.size() + " criteria\n";
        ret = ret + "Alternatives: " + this.alternatives + "\n";
        ret = ret + "Criteria: " + this.criteria + "\n";
        ret = ret + "Measurements:\n";
        ret = ret + this.impactMatrix.toString() + "\n";
        return ret;
    }

    public synchronized void deleteAlternative(Alternative a) {
        if (this.alternatives.remove(a)) {
            this.impactMatrix.removeListener(this.impactListener);
            this.impactMatrix.deleteAlternative(a);
            this.impactMatrix.addListener(this.impactListener);
            this.fireModelChange(2);
        }
    }

    public synchronized void deleteCriterion(Criterion c) {
        if (this.criteria.remove(c)) {
            c.removePropertyChangeListener(this.critListener);
            this.impactMatrix.removeListener(this.impactListener);
            this.impactMatrix.deleteCriterion(c);
            this.impactMatrix.addListener(this.impactListener);
            this.preferences = new MissingPreferenceInformation(this.getCriteria().size());
            this.fireModelChange(1);
            this.fireModelChange(5);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof SMAAModel)) {
            return false;
        }
        SMAAModel m = (SMAAModel)other;
        if (!m.name.equals(this.name)) {
            return false;
        }
        if (!m.impactMatrix.equals(this.impactMatrix)) {
            return false;
        }
        if (m.preferences == null && this.preferences != null) {
            return false;
        }
        return m.preferences.equals(this.preferences);
    }

    public synchronized SMAAModel deepCopy() {
        SMAAModel model = new SMAAModel(this.name);
        this.deepCopyContents(model);
        return model;
    }

    protected void deepCopyContents(SMAAModel model) {
        for (Alternative a : this.alternatives) {
            model.addAlternative(a.deepCopy());
        }
        for (Criterion c : this.criteria) {
            model.addCriterion((Criterion)c.deepCopy());
        }
        model.impactMatrix = this.impactMatrix.deepCopy(model.getAlternatives(), model.getCriteria());
        model.impactMatrix.addListener(model.impactListener);
        model.setPreferenceInformation((PreferenceInformation)this.preferences.deepCopy());
    }

    public void setMissingPreferences() {
        this.setPreferenceInformation(new MissingPreferenceInformation(this.getCriteria().size()));
    }

    private void readObject(ObjectInputStream i) throws IOException, ClassNotFoundException {
        this.modelListeners = new ArrayList<SMAAModelListener>();
        this.impactListener = new ImpactListener();
        this.critListener = new CriteriaListener();
        i.defaultReadObject();
        this.impactMatrix.addListener(this.impactListener);
        this.connectCriteriaListeners(this.getCriteria());
        this.preferences.addPropertyChangeListener(new MyPreferenceListener());
    }

    protected void fireModelChange(int type) {
        ModelChangeEvent ev = new ModelChangeEvent(this, type);
        for (SMAAModelListener l : this.modelListeners) {
            l.modelChanged(ev);
        }
    }

    public ImpactMatrix getImpactMatrix() {
        return this.impactMatrix;
    }

    public void reorderAlternatives(List<Alternative> newAlts) {
        this.alternatives = newAlts;
        this.impactMatrix.reorderAlternatives(newAlts);
        this.fireModelChange(2);
    }

    public void reorderCriteria(List<Criterion> newCrit) {
        this.criteria = newCrit;
        this.impactMatrix.reorderCriteria(newCrit);
        this.fireModelChange(1);
    }

    private class MyPreferenceListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = 9084801400903300047L;

        private MyPreferenceListener() {
        }

        public void propertyChange(PropertyChangeEvent arg0) {
            SMAAModel.this.fireModelChange(4);
        }
    }

    private class ImpactListener
    implements ImpactMatrixListener {
        private ImpactListener() {
        }

        public void measurementChanged() {
            SMAAModel.this.fireModelChange(6);
        }

        public void measurementTypeChanged() {
            SMAAModel.this.fireModelChange(3);
        }
    }

    private class CriteriaListener
    implements PropertyChangeListener {
        private CriteriaListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (!evt.getPropertyName().equals(SMAAModel.PROPERTY_NAME)) {
                SMAAModel.this.fireModelChange(6);
            }
        }
    }
}

