/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.BaselineGaussianMeasurement;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.GaussianMeasurement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public abstract class RelativeGaussianMeasurementBase
extends CardinalMeasurement {
    private static final long serialVersionUID = -4052031951942599415L;
    public static final String PROPERTY_BASELINE = "baseline";
    public static final String PROPERTY_RELATIVE = "relative";
    private BaselineGaussianMeasurement d_baseline;
    private GaussianMeasurement d_relative;
    private PropertyChangeListener nestedListener = new PropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getSource() == RelativeGaussianMeasurementBase.this.d_baseline) {
                RelativeGaussianMeasurementBase.this.firePropertyChange(RelativeGaussianMeasurementBase.PROPERTY_BASELINE, null, RelativeGaussianMeasurementBase.this.d_baseline);
            } else if (event.getSource() == RelativeGaussianMeasurementBase.this.d_relative) {
                RelativeGaussianMeasurementBase.this.firePropertyChange(RelativeGaussianMeasurementBase.PROPERTY_RELATIVE, null, RelativeGaussianMeasurementBase.this.d_relative);
            }
        }
    };
    protected static final XMLFormat<RelativeGaussianMeasurementBase> XML = new XMLFormat<RelativeGaussianMeasurementBase>(RelativeGaussianMeasurementBase.class){

        @Override
        public boolean isReferenceable() {
            return GaussianMeasurement.XML.isReferenceable();
        }

        @Override
        public void read(XMLFormat.InputElement ie, RelativeGaussianMeasurementBase meas) throws XMLStreamException {
            meas.setBaseline(ie.get(RelativeGaussianMeasurementBase.PROPERTY_BASELINE, BaselineGaussianMeasurement.class));
            meas.setRelative(ie.get(RelativeGaussianMeasurementBase.PROPERTY_RELATIVE, GaussianMeasurement.class));
        }

        @Override
        public void write(RelativeGaussianMeasurementBase meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.add(meas.getBaseline(), RelativeGaussianMeasurementBase.PROPERTY_BASELINE, BaselineGaussianMeasurement.class);
            oe.add(meas.getRelative(), RelativeGaussianMeasurementBase.PROPERTY_RELATIVE, GaussianMeasurement.class);
        }
    };

    public RelativeGaussianMeasurementBase(BaselineGaussianMeasurement baseline, GaussianMeasurement relative) {
        this.d_baseline = baseline;
        this.d_baseline.addPropertyChangeListener(this.nestedListener);
        this.d_relative = relative;
        this.d_relative.addPropertyChangeListener(this.nestedListener);
    }

    protected abstract RelativeGaussianMeasurementBase newInstance();

    public boolean equals(Object obj) {
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        RelativeGaussianMeasurementBase m = (RelativeGaussianMeasurementBase)obj;
        return m.getBaseline().equals(this.getBaseline()) && m.getRelative().equals(this.getRelative());
    }

    public RelativeGaussianMeasurementBase deepCopy() {
        RelativeGaussianMeasurementBase copy = this.newInstance();
        copy.setBaseline(this.getBaseline().deepCopy());
        copy.setRelative(this.getRelative().deepCopy());
        return copy;
    }

    public String toString() {
        return "ilogit(" + this.d_baseline.toString() + " + " + this.d_relative.toString() + ")";
    }

    protected Double getAbsoluteStdDev() {
        double s1 = this.d_baseline.getStDev();
        double s2 = this.d_relative.getStDev();
        return Math.sqrt(s1 * s1 + s2 * s2);
    }

    protected double getAbsoluteMean() {
        return this.d_baseline.getMean() + this.d_relative.getMean();
    }

    public double sample() {
        return this.getBaseline().sample() + this.getRelative().sample();
    }

    public BaselineGaussianMeasurement getBaseline() {
        return this.d_baseline;
    }

    void setBaseline(BaselineGaussianMeasurement m) {
        this.d_baseline.removePropertyChangeListener(this.nestedListener);
        this.d_baseline = m;
        this.d_relative.addPropertyChangeListener(this.nestedListener);
    }

    public GaussianMeasurement getRelative() {
        return this.d_relative;
    }

    private void setRelative(GaussianMeasurement m) {
        this.d_relative.removePropertyChangeListener(this.nestedListener);
        this.d_relative = m;
        this.d_relative.addPropertyChangeListener(this.nestedListener);
    }
}

