/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.DeepCopiable;
import fi.smaa.jsmaa.model.Rank;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RankSet<T extends DeepCopiable<T>>
implements DeepCopiable<RankSet<T>>,
Serializable {
    private static final long serialVersionUID = -2783389914146035900L;
    private transient RankListener rankListener = new RankListener();
    private Map<T, Rank> map = new HashMap<T, Rank>();

    public RankSet() {
    }

    public RankSet(Map<T, Rank> map) {
        for (int i = 1; i <= map.entrySet().size(); ++i) {
            if (map.values().contains(new Rank(i))) continue;
            throw new IllegalArgumentException("map doesn't contain all ranks 1,...,n");
        }
        this.map = map;
        this.connectRankListeners();
    }

    private void connectRankListeners() {
        for (Rank r : this.map.values()) {
            r.addPropertyChangeListener(this.rankListener);
        }
    }

    public void addObject(T o) {
        if (!this.map.containsKey(o)) {
            this.map.put(o, this.createNextAvailableRank());
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.rankListener = new RankListener();
        this.connectRankListeners();
    }

    private Rank createNextAvailableRank() {
        int maxRank = 0;
        for (Rank r : this.map.values()) {
            int rn = r.getRank();
            if (rn <= maxRank) continue;
            maxRank = rn;
        }
        Rank newRank = new Rank(maxRank + 1);
        newRank.addPropertyChangeListener(this.rankListener);
        return newRank;
    }

    public Set<T> getObjects() {
        return this.map.keySet();
    }

    public Rank getRank(T o) {
        return this.map.get(o);
    }

    public void deleteObject(T o) {
        if (this.map.containsKey(o)) {
            Rank r = this.map.get(o);
            this.map.remove(o);
            this.shiftDownOneFrom(r.getRank());
        }
    }

    private void shiftDownOneFrom(int rank) {
        for (Rank r : this.map.values()) {
            r.removePropertyChangeListener(this.rankListener);
        }
        for (Rank r : this.map.values()) {
            int oRank = r.getRank();
            if (oRank <= rank) continue;
            r.setRank(oRank - 1);
        }
        for (Rank r : this.map.values()) {
            r.addPropertyChangeListener(this.rankListener);
        }
    }

    private void ensureRanks(Rank r, int oldVal, int newVal) {
        for (Rank ra : this.map.values()) {
            if (ra.getRank() != newVal || ra == r) continue;
            ra.setRank(oldVal);
        }
    }

    @Override
    public RankSet<T> deepCopy() {
        RankSet<T> newSet = new RankSet<T>();
        HashMap<T, Rank> newMap = new HashMap<T, Rank>();
        for (DeepCopiable t : this.map.keySet()) {
            Rank r = this.map.get(t);
            newMap.put(t, r.deepCopy());
        }
        newSet.map = newMap;
        for (Rank r : newMap.values()) {
            r.addPropertyChangeListener(newSet.rankListener);
        }
        return newSet;
    }

    private class RankListener
    implements PropertyChangeListener {
        private RankListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("rank")) {
                int newVal;
                Rank r = (Rank)evt.getSource();
                int oldVal = (Integer)evt.getOldValue();
                if (oldVal != (newVal = ((Integer)evt.getNewValue()).intValue())) {
                    RankSet.this.ensureRanks(r, oldVal, newVal);
                }
            }
        }
    }
}

