/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.CardinalCriterion;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.ExactMeasurement;
import fi.smaa.jsmaa.simulator.IterationException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public final class OutrankingCriterion
extends CardinalCriterion {
    public static final String PROPERTY_INDIF_MEASUREMENT = "indifMeasurement";
    public static final String PROPERTY_PREF_MEASUREMENT = "prefMeasurement";
    private static final long serialVersionUID = 2226047865113684859L;
    private double indifferenceThreshold;
    private double preferenceThreshold;
    private CardinalMeasurement indifMeasurement;
    private CardinalMeasurement prefMeasurement;
    private static final XMLFormat<OutrankingCriterion> XML = new XMLFormat<OutrankingCriterion>(OutrankingCriterion.class){

        @Override
        public OutrankingCriterion newInstance(Class<OutrankingCriterion> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new OutrankingCriterion(ie.getAttribute("name", null), ie.getAttribute("ascending", true), new ExactMeasurement(0.0), new ExactMeasurement(1.0));
        }

        @Override
        public boolean isReferenceable() {
            return CardinalCriterion.XML.isReferenceable();
        }

        @Override
        public void read(XMLFormat.InputElement ie, OutrankingCriterion crit) throws XMLStreamException {
            CardinalCriterion.XML.read(ie, crit);
            crit.indifMeasurement = (CardinalMeasurement)ie.get("indifferenceTH");
            crit.prefMeasurement = (CardinalMeasurement)ie.get("preferenceTH");
        }

        @Override
        public void write(OutrankingCriterion crit, XMLFormat.OutputElement oe) throws XMLStreamException {
            CardinalCriterion.XML.write(crit, oe);
            oe.add(crit.indifMeasurement, "indifferenceTH");
            oe.add(crit.prefMeasurement, "preferenceTH");
        }
    };

    public OutrankingCriterion(String name, boolean ascending, CardinalMeasurement indifMeasurement, CardinalMeasurement prefMeasurement) {
        super(name, ascending);
        this.setIndifMeasurement(indifMeasurement);
        this.setPrefMeasurement(prefMeasurement);
        this.indifferenceThreshold = indifMeasurement.sample();
        this.preferenceThreshold = prefMeasurement.sample();
    }

    public void sampleThresholds() throws IterationException {
        for (int i = 0; i < 1000; ++i) {
            this.indifferenceThreshold = this.indifMeasurement.sample();
            this.preferenceThreshold = this.prefMeasurement.sample();
            if (!(this.indifferenceThreshold <= this.preferenceThreshold)) continue;
            return;
        }
        throw new IterationException("Cannot sample thresholds for " + this.getName() + ": indifference > preference");
    }

    public double getIndifferenceThreshold() {
        return this.indifferenceThreshold;
    }

    public void setIndifMeasurement(CardinalMeasurement indifMeasurement) {
        CardinalMeasurement oldVal = this.indifMeasurement;
        this.indifMeasurement = indifMeasurement;
        this.indifMeasurement.addPropertyChangeListener(new IndifListener());
        this.firePropertyChange(PROPERTY_INDIF_MEASUREMENT, oldVal, this.indifMeasurement);
    }

    public void setPrefMeasurement(CardinalMeasurement prefMeasurement) {
        CardinalMeasurement oldVal = this.prefMeasurement;
        this.prefMeasurement = prefMeasurement;
        this.prefMeasurement.addPropertyChangeListener(new PrefListener());
        this.firePropertyChange(PROPERTY_PREF_MEASUREMENT, oldVal, this.prefMeasurement);
    }

    public CardinalMeasurement getIndifMeasurement() {
        return this.indifMeasurement;
    }

    public CardinalMeasurement getPrefMeasurement() {
        return this.prefMeasurement;
    }

    public double getPreferenceThreshold() {
        return this.preferenceThreshold;
    }

    public String getTypeLabel() {
        return "Outranking";
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.prefMeasurement.addPropertyChangeListener(new PrefListener());
        this.indifMeasurement.addPropertyChangeListener(new IndifListener());
    }

    public OutrankingCriterion deepCopy() {
        return new OutrankingCriterion(this.name, this.ascending, (CardinalMeasurement)this.indifMeasurement.deepCopy(), (CardinalMeasurement)this.prefMeasurement.deepCopy());
    }

    private class IndifListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -5202261775299851878L;

        private IndifListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            OutrankingCriterion.this.firePropertyChange(OutrankingCriterion.PROPERTY_INDIF_MEASUREMENT, null, OutrankingCriterion.this.getIndifMeasurement());
        }
    }

    private class PrefListener
    implements PropertyChangeListener,
    Serializable {
        private static final long serialVersionUID = -2064991382287461823L;

        private PrefListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            OutrankingCriterion.this.firePropertyChange(OutrankingCriterion.PROPERTY_PREF_MEASUREMENT, null, OutrankingCriterion.this.getPrefMeasurement());
        }
    }
}

