/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.AbstractPreferenceInformation;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.Rank;
import fi.smaa.jsmaa.model.RankSampler;
import fi.smaa.jsmaa.model.RankSet;
import fi.smaa.jsmaa.model.xml.CriterionMeasurementPair;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OrdinalPreferenceInformation
extends AbstractPreferenceInformation<Rank> {
    private static final long serialVersionUID = -8011596971699184854L;
    private transient double[] tmparr;
    private transient double[] samplearr;
    private RankSet<Criterion> ranks = new RankSet();
    private static final XMLFormat<OrdinalPreferenceInformation> XML = new XMLFormat<OrdinalPreferenceInformation>(OrdinalPreferenceInformation.class){

        @Override
        public OrdinalPreferenceInformation newInstance(Class<OrdinalPreferenceInformation> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new OrdinalPreferenceInformation(new ArrayList<Criterion>());
        }

        @Override
        public boolean isReferenceable() {
            return true;
        }

        @Override
        public void read(XMLFormat.InputElement ie, OrdinalPreferenceInformation pref) throws XMLStreamException {
            while (ie.hasNext()) {
                CriterionMeasurementPair p = ie.get("preference", CriterionMeasurementPair.class);
                pref.criteria.add(p.getCriterion());
                pref.ranks.addObject(p.getCriterion());
                pref.ranks.getRank(p.getCriterion()).setRank(((Rank)p.getMeasurement()).getRank());
            }
            pref.connectRankListener();
        }

        @Override
        public void write(OrdinalPreferenceInformation pref, XMLFormat.OutputElement oe) throws XMLStreamException {
            for (Criterion c : pref.criteria) {
                CriterionMeasurementPair p = new CriterionMeasurementPair(c, pref.getMeasurement(c));
                oe.add(p, "preference", CriterionMeasurementPair.class);
            }
        }
    };

    public OrdinalPreferenceInformation(List<Criterion> criteria) {
        super(criteria);
        for (Criterion c : criteria) {
            this.ranks.addObject(c);
        }
        this.connectRankListener();
    }

    @Override
    public Rank getMeasurement(Criterion c) {
        return this.ranks.getRank(c);
    }

    public List<Rank> getRanks() {
        ArrayList<Rank> rankList = new ArrayList<Rank>();
        for (Criterion c : this.criteria) {
            rankList.add(this.ranks.getRank(c));
        }
        return rankList;
    }

    private void initArrays() {
        if (this.tmparr == null) {
            this.tmparr = new double[this.criteria.size()];
        }
        if (this.samplearr == null) {
            this.samplearr = new double[this.criteria.size()];
        }
    }

    @Override
    public double[] sampleWeights() {
        this.initArrays();
        ArrayList<Integer> rankList = new ArrayList<Integer>();
        for (Criterion c : this.criteria) {
            rankList.add(this.ranks.getRank(c).getRank());
        }
        RankSampler r = new RankSampler(rankList);
        return r.sampleWeights();
    }

    public String toString() {
        return this.getRanks().toString();
    }

    @Override
    public OrdinalPreferenceInformation deepCopy() {
        OrdinalPreferenceInformation inf = new OrdinalPreferenceInformation(new ArrayList<Criterion>(this.criteria));
        inf.ranks = this.ranks.deepCopy();
        inf.connectRankListener();
        return inf;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.connectRankListener();
    }

    private void connectRankListener() {
        for (Criterion c : this.criteria) {
            this.ranks.getRank(c).addPropertyChangeListener(this.measListener);
        }
    }
}

