/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.GaussianMeasurement;
import fi.smaa.jsmaa.model.Interval;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.drugis.common.stat.Statistics;

public class LogitNormalMeasurement
extends GaussianMeasurement {
    private static final long serialVersionUID = -3227427739303388222L;
    protected static final XMLFormat<LogitNormalMeasurement> XML = new XMLFormat<LogitNormalMeasurement>(LogitNormalMeasurement.class){

        @Override
        public LogitNormalMeasurement newInstance(Class<LogitNormalMeasurement> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new LogitNormalMeasurement(ie.getAttribute("mean").toDouble(), ie.getAttribute("stdev").toDouble());
        }

        @Override
        public boolean isReferenceable() {
            return GaussianMeasurement.XML.isReferenceable();
        }

        @Override
        public void read(XMLFormat.InputElement ie, LogitNormalMeasurement meas) throws XMLStreamException {
            GaussianMeasurement.XML.read(ie, meas);
        }

        @Override
        public void write(LogitNormalMeasurement meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            GaussianMeasurement.XML.write(meas, oe);
        }
    };

    public LogitNormalMeasurement(double mean, double stdDev) {
        super(mean, stdDev);
    }

    public double sample() {
        return Statistics.ilogit(super.sample());
    }

    public Interval getRange() {
        return new Interval(0.0, 1.0);
    }

    public boolean equals(Object o) {
        if (o instanceof LogitNormalMeasurement) {
            LogitNormalMeasurement other = (LogitNormalMeasurement)o;
            return other.getMean().equals(this.getMean()) && other.getStDev().equals(this.getStDev());
        }
        return false;
    }

    public LogitNormalMeasurement deepCopy() {
        return new LogitNormalMeasurement((double)this.getMean(), (double)this.getStDev());
    }
}

