/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.GaussianMeasurement;
import fi.smaa.jsmaa.model.Interval;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class LogNormalMeasurement
extends GaussianMeasurement {
    private static final long serialVersionUID = -562511137486161262L;
    protected static final XMLFormat<LogNormalMeasurement> XML = new XMLFormat<LogNormalMeasurement>(LogNormalMeasurement.class){

        @Override
        public LogNormalMeasurement newInstance(Class<LogNormalMeasurement> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new LogNormalMeasurement(ie.getAttribute("mean").toDouble(), ie.getAttribute("stdev").toDouble());
        }

        @Override
        public boolean isReferenceable() {
            return GaussianMeasurement.XML.isReferenceable();
        }

        @Override
        public void read(XMLFormat.InputElement ie, LogNormalMeasurement meas) throws XMLStreamException {
            GaussianMeasurement.XML.read(ie, meas);
        }

        @Override
        public void write(LogNormalMeasurement meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            GaussianMeasurement.XML.write(meas, oe);
        }
    };

    public LogNormalMeasurement(double mean, double stdev) {
        super(mean, stdev);
    }

    public LogNormalMeasurement() {
    }

    public Interval getRange() {
        return new Interval(Math.exp(this.mean - this.stDev * 1.96), Math.exp(this.mean + this.stDev * 1.96));
    }

    public LogNormalMeasurement deepCopy() {
        return new LogNormalMeasurement((double)this.mean, (double)this.stDev);
    }

    public double sample() {
        return Math.exp(super.sample());
    }

    public boolean equals(Object other) {
        if (!(other instanceof LogNormalMeasurement)) {
            return false;
        }
        return super.valueEquals((LogNormalMeasurement)other);
    }
}

