/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.common.RandomUtil;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.InvalidIntervalException;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Iterator;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Interval
extends CardinalMeasurement {
    private static final long serialVersionUID = -4036986804177522602L;
    public static final String PROPERTY_START = "start";
    public static final String PROPERTY_END = "end";
    private Double start;
    private Double end;
    private static final XMLFormat<Interval> XML = new XMLFormat<Interval>(Interval.class){

        @Override
        public Interval newInstance(Class<Interval> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new Interval(ie.getAttribute(Interval.PROPERTY_START).toDouble(), ie.getAttribute(Interval.PROPERTY_END).toDouble());
        }

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public void read(XMLFormat.InputElement ie, Interval meas) throws XMLStreamException {
            meas.start = ie.getAttribute(Interval.PROPERTY_START).toDouble();
            meas.end = ie.getAttribute(Interval.PROPERTY_END).toDouble();
        }

        @Override
        public void write(Interval meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.setAttribute(Interval.PROPERTY_START, meas.start.toString());
            oe.setAttribute(Interval.PROPERTY_END, meas.end.toString());
        }
    };

    public Interval() {
        this.start = 0.0;
        this.end = 0.0;
    }

    public Interval(Double start, Double end) throws InvalidIntervalException {
        if (end < start) {
            throw new InvalidIntervalException();
        }
        this.start = start;
        this.end = end;
    }

    public Double getStart() {
        return this.start;
    }

    public Double getEnd() {
        return this.end;
    }

    public void setStart(Double start) {
        Double oldVal = this.start;
        this.start = start;
        this.firePropertyChange(PROPERTY_START, oldVal, this.start);
    }

    public void setEnd(Double end) {
        Double oldVal = this.end;
        this.end = end;
        this.firePropertyChange(PROPERTY_END, oldVal, this.end);
    }

    public String toString() {
        DecimalFormat fmt = new DecimalFormat("#0.00");
        return "[" + fmt.format(this.start) + " - " + fmt.format(this.end) + "]";
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Interval)) {
            return false;
        }
        Interval io = (Interval)other;
        return this.getStart().equals(io.getStart()) && this.getEnd().equals(io.getEnd());
    }

    public static Interval enclosingInterval(Collection<Interval> intervals) {
        if (intervals.size() == 0) {
            return null;
        }
        Iterator<Interval> it = intervals.iterator();
        Interval enclosing = it.next().deepCopy();
        while (it.hasNext()) {
            Interval other = it.next();
            if (other.getStart() < enclosing.getStart()) {
                enclosing.setStart(other.getStart());
            }
            if (!(other.getEnd() > enclosing.getEnd())) continue;
            enclosing.setEnd(other.getEnd());
        }
        return enclosing;
    }

    public Double getLength() {
        return this.end - this.start;
    }

    public boolean includes(Interval other) {
        return other.getStart() >= this.getStart() && other.getEnd() <= this.getEnd();
    }

    @Override
    public Interval deepCopy() {
        return new Interval(this.start, this.end);
    }

    @Override
    public Interval getRange() {
        return this;
    }

    @Override
    public double sample() {
        return this.getStart() + RandomUtil.createUnif01() * (this.getEnd() - this.getStart());
    }

    public boolean includes(Double val) {
        return val >= this.getStart() && val <= this.getEnd();
    }

    public Double getMiddle() {
        return (this.getStart() + this.getEnd()) / 2.0;
    }
}

