/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.AbstractEntity;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.BaselineGaussianMeasurement;
import fi.smaa.jsmaa.model.CardinalCriterion;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ImpactMatrixListener;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.Measurement;
import fi.smaa.jsmaa.model.OrdinalCriterion;
import fi.smaa.jsmaa.model.Rank;
import fi.smaa.jsmaa.model.RankSet;
import fi.smaa.jsmaa.model.RelativeGaussianMeasurementBase;
import fi.smaa.jsmaa.model.ScaleCriterion;
import fi.smaa.jsmaa.model.xml.CriterionAlternativeMeasurement;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImpactMatrix
extends AbstractEntity {
    private static final long serialVersionUID = -5524839710856011441L;
    private List<Criterion> criteria = new ArrayList<Criterion>();
    private List<Alternative> alternatives = new ArrayList<Alternative>();
    private Map<Criterion, Map<Alternative, Measurement>> measurements = new HashMap<Criterion, Map<Alternative, Measurement>>();
    private Map<Criterion, BaselineGaussianMeasurement> baselines = new HashMap<Criterion, BaselineGaussianMeasurement>();
    private transient MeasurementListener measListener = new MeasurementListener();
    private transient List<ImpactMatrixListener> thisListeners = new ArrayList<ImpactMatrixListener>();
    private transient Map<Criterion, RankSet<Alternative>> ordinalCriteriaRanksSets = new HashMap<Criterion, RankSet<Alternative>>();
    private static final XMLFormat<ImpactMatrix> XML = new XMLFormat<ImpactMatrix>(ImpactMatrix.class){

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public ImpactMatrix newInstance(Class<ImpactMatrix> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new ImpactMatrix();
        }

        @Override
        public void read(XMLFormat.InputElement ie, ImpactMatrix mat) throws XMLStreamException {
            while (ie.hasNext()) {
                CriterionAlternativeMeasurement m = ie.get("measurement", CriterionAlternativeMeasurement.class);
                mat.addAlternative(m.getAlternative());
                mat.addCriterion(m.getCriterion());
                mat.setMeasurement(m.getCriterion(), m.getAlternative(), m.getMeasurement());
                if (!(m.getMeasurement() instanceof RelativeGaussianMeasurementBase)) continue;
                RelativeGaussianMeasurementBase rm = (RelativeGaussianMeasurementBase)m.getMeasurement();
                mat.setBaseline(m.getCriterion(), rm.getBaseline());
            }
        }

        @Override
        public void write(ImpactMatrix mat, XMLFormat.OutputElement oe) throws XMLStreamException {
            for (Criterion c : mat.getCriteria()) {
                for (Alternative a : mat.getAlternatives()) {
                    CriterionAlternativeMeasurement m = new CriterionAlternativeMeasurement(a, c, mat.getMeasurement(c, a));
                    oe.add(m, "measurement", CriterionAlternativeMeasurement.class);
                }
            }
        }
    };

    public ImpactMatrix() {
    }

    public String toString() {
        return this.measurements.toString();
    }

    public ImpactMatrix(List<Alternative> alternatives, List<Criterion> criteria) {
        for (Criterion c : criteria) {
            this.addCriterion(c);
        }
        for (Alternative a : alternatives) {
            this.addAlternative(a);
        }
    }

    public boolean equals(Object other) {
        if (!(other instanceof ImpactMatrix)) {
            return false;
        }
        ImpactMatrix m = (ImpactMatrix)other;
        if (!((Object)this.criteria).equals(m.criteria)) {
            return false;
        }
        if (!((Object)this.alternatives).equals(m.alternatives)) {
            return false;
        }
        if (!((Object)this.measurements).equals(m.measurements)) {
            return false;
        }
        return ((Object)this.baselines).equals(m.baselines);
    }

    public void addListener(ImpactMatrixListener l) {
        if (this.thisListeners.contains(l)) {
            return;
        }
        this.thisListeners.add(l);
    }

    public void removeListener(ImpactMatrixListener l) {
        this.thisListeners.remove(l);
    }

    public void setMeasurement(Criterion crit, Alternative alt, Measurement meas) {
        if (meas == null) {
            throw new NullPointerException("null measurement");
        }
        this.assertExistAlternativeAndCriterion(crit, alt);
        this.setMeasurementNoFires(crit, alt, meas);
        if (crit instanceof ScaleCriterion) {
            this.updateScales();
        }
        this.fireMeasurementTypeChanged();
    }

    private void setMeasurementNoFires(Criterion crit, Alternative alt, Measurement meas) {
        this.disconnectConnectMeasurementListener(crit, alt, meas);
        this.measurements.get(crit).put(alt, meas);
    }

    public Measurement getMeasurement(Criterion crit, Alternative alt) {
        this.assertExistAlternativeAndCriterion(crit, alt);
        return this.measurements.get(crit).get(alt);
    }

    public void deleteAlternative(Alternative alt) {
        if (!this.alternatives.contains(alt)) {
            return;
        }
        this.alternatives.remove(alt);
        for (RankSet<Alternative> set : this.ordinalCriteriaRanksSets.values()) {
            set.deleteObject(alt);
        }
        this.updateScales();
    }

    public void addAlternative(Alternative alt) {
        if (this.alternatives.contains(alt)) {
            return;
        }
        this.alternatives.add(alt);
        for (Criterion c : this.criteria) {
            Map<Alternative, Measurement> map = this.measurements.get(c);
            if (map.keySet().contains(alt)) continue;
            if (c instanceof CardinalCriterion) {
                this.setMeasurementNoFires(c, alt, new Interval());
                continue;
            }
            if (!(c instanceof OrdinalCriterion)) continue;
            this.ordinalCriteriaRanksSets.get(c).addObject(alt);
            Rank r = this.ordinalCriteriaRanksSets.get(c).getRank(alt);
            this.setMeasurementNoFires(c, alt, r);
        }
        this.updateScales();
    }

    public void deleteCriterion(Criterion c) {
        if (!this.criteria.contains(c)) {
            return;
        }
        this.criteria.remove(c);
        this.measurements.remove(c);
        this.ordinalCriteriaRanksSets.remove(c);
        this.baselines.remove(c);
    }

    public void addCriterion(Criterion c) {
        if (this.criteria.contains(c)) {
            return;
        }
        this.criteria.add(c);
        HashMap newMap = new HashMap();
        this.measurements.put(c, newMap);
        if (c instanceof OrdinalCriterion) {
            RankSet<Alternative> rs = new RankSet<Alternative>();
            this.ordinalCriteriaRanksSets.put(c, rs);
            for (Alternative a : this.alternatives) {
                rs.addObject(a);
                Rank r = rs.getRank(a);
                this.setMeasurementNoFires(c, a, r);
            }
        } else if (c instanceof CardinalCriterion) {
            this.baselines.put(c, new BaselineGaussianMeasurement());
            for (Alternative a : this.alternatives) {
                if (this.getMeasurement(c, a) != null) continue;
                this.setMeasurementNoFires(c, a, new Interval());
            }
        }
        if (c instanceof ScaleCriterion) {
            this.updateScales();
        }
    }

    public List<Alternative> getAlternatives() {
        return this.alternatives;
    }

    public List<Criterion> getCriteria() {
        return this.criteria;
    }

    private void updateScales() {
        for (Criterion c : this.criteria) {
            if (!(c instanceof ScaleCriterion)) continue;
            Map<Alternative, Measurement> cMeas = this.measurements.get(c);
            ArrayList<Interval> ivals = new ArrayList<Interval>();
            for (Measurement m : cMeas.values()) {
                CardinalMeasurement cm = (CardinalMeasurement)m;
                ivals.add(cm.getRange());
            }
            Interval scale = ivals.size() == 0 ? new Interval(0.0, 0.0) : Interval.enclosingInterval(ivals);
            ((ScaleCriterion)c).setScale(scale);
        }
    }

    private void assertExistAlternativeAndCriterion(Criterion crit, Alternative alt) {
        assert (this.criteria.contains(crit));
        assert (this.alternatives.contains(alt));
    }

    private void readObject(ObjectInputStream i) throws IOException, ClassNotFoundException {
        i.defaultReadObject();
        this.measListener = new MeasurementListener();
        this.thisListeners = new ArrayList<ImpactMatrixListener>();
        this.ordinalCriteriaRanksSets = new HashMap<Criterion, RankSet<Alternative>>();
        for (Criterion criterion : this.criteria) {
            if (!(criterion instanceof OrdinalCriterion)) continue;
            HashMap<Alternative, Rank> ranks = new HashMap<Alternative, Rank>();
            for (Alternative a : this.alternatives) {
                ranks.put(a, (Rank)this.getMeasurement(criterion, a));
            }
            this.ordinalCriteriaRanksSets.put(criterion, new RankSet(ranks));
        }
        for (Map map : this.measurements.values()) {
            for (Measurement meas : map.values()) {
                if (meas == null) continue;
                meas.addPropertyChangeListener(this.measListener);
            }
        }
    }

    private void disconnectConnectMeasurementListener(Criterion crit, Alternative alt, Measurement meas) {
        if (meas == null) {
            throw new NullPointerException("null measurement");
        }
        Measurement m = this.measurements.get(crit).get(alt);
        if (m != null) {
            m.removePropertyChangeListener(this.measListener);
        }
        meas.addPropertyChangeListener(this.measListener);
    }

    private void fireMeasurementChanged() {
        for (ImpactMatrixListener l : this.thisListeners) {
            l.measurementChanged();
        }
    }

    private void fireMeasurementTypeChanged() {
        for (ImpactMatrixListener l : this.thisListeners) {
            l.measurementTypeChanged();
        }
    }

    public ImpactMatrix deepCopy(List<Alternative> alts, List<Criterion> crit) {
        if (this.getAlternatives().size() != alts.size()) {
            throw new IllegalArgumentException("ImpactMatrix.deepCopy() : getAlternatives().size() != alts.size()");
        }
        if (this.getCriteria().size() != crit.size()) {
            throw new IllegalArgumentException("ImpactMatrix.deepCopy() : getCriteria().size() != crit.size()");
        }
        ImpactMatrix other = new ImpactMatrix(alts, crit);
        int cIndex = 0;
        for (Criterion c : this.getCriteria()) {
            int aIndex = 0;
            if (this.getBaseline(c) != null) {
                other.setBaseline(crit.get(cIndex), this.getBaseline(c).deepCopy());
            }
            for (Alternative a : this.getAlternatives()) {
                Measurement m = (Measurement)this.getMeasurement(c, a).deepCopy();
                if (m instanceof RelativeGaussianMeasurementBase) {
                    ((RelativeGaussianMeasurementBase)m).setBaseline(other.getBaseline(crit.get(cIndex)));
                }
                other.setMeasurement(crit.get(cIndex), alts.get(aIndex), m);
                ++aIndex;
            }
            ++cIndex;
        }
        return other;
    }

    public void setBaseline(Criterion c, BaselineGaussianMeasurement m) {
        this.baselines.put(c, m);
    }

    public BaselineGaussianMeasurement getBaseline(Criterion c) {
        return this.baselines.get(c);
    }

    public void reorderAlternatives(List<Alternative> newAlts) {
        this.alternatives = newAlts;
    }

    public void reorderCriteria(List<Criterion> newCrit) {
        this.criteria = newCrit;
    }

    private class MeasurementListener
    implements PropertyChangeListener {
        private MeasurementListener() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getSource() instanceof CardinalMeasurement) {
                ImpactMatrix.this.updateScales();
            }
            ImpactMatrix.this.fireMeasurementChanged();
        }
    }
}

