/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.common.RandomUtil;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Interval;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public class GaussianMeasurement
extends CardinalMeasurement {
    private static final long serialVersionUID = 1821014379633287612L;
    public static final String PROPERTY_MEAN = "mean";
    public static final String PROPERTY_STDEV = "stDev";
    protected Double mean;
    protected Double stDev;
    protected static final XMLFormat<GaussianMeasurement> XML = new XMLFormat<GaussianMeasurement>(GaussianMeasurement.class){

        @Override
        public GaussianMeasurement newInstance(Class<GaussianMeasurement> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new GaussianMeasurement(ie.getAttribute(GaussianMeasurement.PROPERTY_MEAN).toDouble(), ie.getAttribute("stdev").toDouble());
        }

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public void read(XMLFormat.InputElement ie, GaussianMeasurement meas) throws XMLStreamException {
            meas.mean = ie.getAttribute(GaussianMeasurement.PROPERTY_MEAN).toDouble();
            meas.stDev = ie.getAttribute("stdev").toDouble();
        }

        @Override
        public void write(GaussianMeasurement meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.setAttribute(GaussianMeasurement.PROPERTY_MEAN, meas.mean);
            oe.setAttribute("stdev", meas.stDev);
        }
    };

    public GaussianMeasurement(Double mean, Double stDev) {
        assert (stDev >= 0.0);
        this.mean = mean;
        this.stDev = stDev;
    }

    public GaussianMeasurement() {
        this.mean = 0.0;
        this.stDev = 0.0;
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double mean) {
        Double oldVal = this.mean;
        this.mean = mean;
        this.firePropertyChange(PROPERTY_MEAN, oldVal, this.mean);
    }

    public Double getStDev() {
        return this.stDev;
    }

    public void setStDev(Double stDev) {
        Double oldVal = this.stDev;
        this.stDev = stDev;
        this.firePropertyChange(PROPERTY_STDEV, oldVal, this.stDev);
    }

    public String toString() {
        return this.mean + "\u00b1" + this.stDev;
    }

    public GaussianMeasurement deepCopy() {
        return new GaussianMeasurement(this.mean, this.stDev);
    }

    public Interval getRange() {
        return new Interval(this.mean - this.stDev * 1.96, this.mean + this.stDev * 1.96);
    }

    public double sample() {
        return RandomUtil.createGaussian(this.mean, this.stDev);
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(GaussianMeasurement.class)) {
            return false;
        }
        GaussianMeasurement go = (GaussianMeasurement)other;
        return this.valueEquals(go);
    }

    protected boolean valueEquals(GaussianMeasurement go) {
        return go.mean.equals(this.mean) && go.stDev.equals(this.stDev);
    }
}

