/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Interval;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

public final class ExactMeasurement
extends CardinalMeasurement {
    private static final long serialVersionUID = 1661283322088107801L;
    private Double val;
    public static final String PROPERTY_VALUE = "value";
    private static final XMLFormat<ExactMeasurement> XML = new XMLFormat<ExactMeasurement>(ExactMeasurement.class){

        @Override
        public ExactMeasurement newInstance(Class<ExactMeasurement> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new ExactMeasurement(ie.getAttribute(ExactMeasurement.PROPERTY_VALUE).toDouble());
        }

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public void read(XMLFormat.InputElement ie, ExactMeasurement meas) throws XMLStreamException {
            meas.val = ie.getAttribute(ExactMeasurement.PROPERTY_VALUE).toDouble();
        }

        @Override
        public void write(ExactMeasurement meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.setAttribute(ExactMeasurement.PROPERTY_VALUE, meas.val);
        }
    };

    public ExactMeasurement(Double val) {
        this.val = val;
    }

    public Double getValue() {
        return this.val;
    }

    public void setValue(Double value) {
        Double oldVal = this.val;
        this.val = value;
        this.firePropertyChange(PROPERTY_VALUE, oldVal, this.val);
    }

    public Interval getRange() {
        return new Interval(this.val, this.val);
    }

    public double sample() {
        return this.val;
    }

    public ExactMeasurement deepCopy() {
        return new ExactMeasurement(this.val);
    }

    public boolean equals(Object o) {
        if (!(o instanceof ExactMeasurement)) {
            return false;
        }
        ExactMeasurement em = (ExactMeasurement)o;
        return em.getValue().equals(this.getValue());
    }
}

