/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.common.RandomUtil;
import fi.smaa.jsmaa.model.AbstractPreferenceInformation;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Criterion;
import fi.smaa.jsmaa.model.ExactMeasurement;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.xml.CriterionMeasurementPair;
import fi.smaa.jsmaa.simulator.IterationException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CardinalPreferenceInformation
extends AbstractPreferenceInformation<CardinalMeasurement> {
    private static final long serialVersionUID = 5119910625472241337L;
    private static final int MAXGENITERS = 10000;
    protected Map<Criterion, CardinalMeasurement> prefs = new HashMap<Criterion, CardinalMeasurement>();
    private static final XMLFormat<CardinalPreferenceInformation> XML = new XMLFormat<CardinalPreferenceInformation>(CardinalPreferenceInformation.class){

        @Override
        public CardinalPreferenceInformation newInstance(Class<CardinalPreferenceInformation> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new CardinalPreferenceInformation(new ArrayList<Criterion>());
        }

        @Override
        public boolean isReferenceable() {
            return true;
        }

        @Override
        public void read(XMLFormat.InputElement ie, CardinalPreferenceInformation pref) throws XMLStreamException {
            CriterionMeasurementPair p = null;
            while (ie.hasNext()) {
                p = ie.get("preference", CriterionMeasurementPair.class);
                pref.criteria.add(p.getCriterion());
                pref.setMeasurement(p.getCriterion(), (CardinalMeasurement)p.getMeasurement());
            }
        }

        @Override
        public void write(CardinalPreferenceInformation pref, XMLFormat.OutputElement oe) throws XMLStreamException {
            for (Criterion c : pref.criteria) {
                CriterionMeasurementPair p = new CriterionMeasurementPair(c, pref.getMeasurement(c));
                oe.add(p, "preference", CriterionMeasurementPair.class);
            }
        }
    };

    public CardinalPreferenceInformation(List<Criterion> criteria) {
        super(criteria);
        this.initMeasurements();
    }

    private void initMeasurements() {
        for (Criterion c : this.criteria) {
            this.setMeasurement(c, new ExactMeasurement(0.0));
        }
    }

    public void setMeasurement(Criterion c, CardinalMeasurement m) {
        CardinalMeasurement oldMeas = this.prefs.get(c);
        if (oldMeas != null) {
            oldMeas.removePropertyChangeListener(this.measListener);
        }
        m.addPropertyChangeListener(this.measListener);
        this.prefs.put(c, m);
        this.firePreferencesChanged();
    }

    @Override
    public CardinalMeasurement getMeasurement(Criterion c) {
        return this.prefs.get(c);
    }

    @Override
    public double[] sampleWeights() throws IterationException {
        double[] weights = new double[this.criteria.size()];
        double lowerBounds = 0.0;
        int numIntervalCriteria = 0;
        for (int i = 0; i < weights.length; ++i) {
            CardinalMeasurement meas = this.prefs.get(this.criteria.get(i));
            if (meas instanceof Interval) {
                ++numIntervalCriteria;
            }
            lowerBounds += meas.getRange().getStart().doubleValue();
        }
        if (lowerBounds > 1.0) {
            throw new IterationException("weight lower bounds over 1.0");
        }
        double[] tmpArr = new double[numIntervalCriteria];
        for (int iter = 0; iter < 10000; ++iter) {
            if (numIntervalCriteria > 0) {
                RandomUtil.createSumToRand(tmpArr, 1.0 - lowerBounds);
            }
            int currentInterval = 0;
            boolean overUpperBound = false;
            for (int i = 0; i < weights.length; ++i) {
                CardinalMeasurement meas = this.prefs.get(this.criteria.get(i));
                if (meas instanceof ExactMeasurement) {
                    weights[i] = ((ExactMeasurement)meas).getValue();
                    continue;
                }
                if (meas instanceof Interval) {
                    weights[i] = meas.getRange().getStart() + tmpArr[currentInterval];
                    if (weights[i] > meas.getRange().getEnd()) {
                        overUpperBound = true;
                        break;
                    }
                    ++currentInterval;
                    continue;
                }
                throw new RuntimeException("unknown weight constraint type");
            }
            if (overUpperBound || !this.checkSumTo1(weights)) continue;
            return weights;
        }
        throw new IterationException("infeasible weight constraints");
    }

    private boolean checkSumTo1(double[] weights) {
        double sum = 0.0;
        for (double d : weights) {
            sum += d;
        }
        return sum == 1.0;
    }

    @Override
    public CardinalPreferenceInformation deepCopy() {
        CardinalPreferenceInformation pref = new CardinalPreferenceInformation(this.criteria);
        for (Criterion c : this.prefs.keySet()) {
            pref.setMeasurement(c, this.prefs.get(c));
        }
        return pref;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        for (Criterion c : this.criteria) {
            this.getMeasurement(c).addPropertyChangeListener(this.measListener);
        }
    }
}

