/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.model;

import fi.smaa.common.RandomUtil;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.Interval;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.distribution.BetaDistributionImpl;

public class BetaMeasurement
extends CardinalMeasurement {
    private static final long serialVersionUID = -7078702411067171274L;
    public static final String PROPERTY_ALPHA = "alpha";
    public static final String PROPERTY_BETA = "beta";
    public static final String PROPERTY_MIN = "min";
    public static final String PROPERTY_MAX = "max";
    private Double alpha;
    private Double beta;
    private Double min;
    private Double max;
    protected static final XMLFormat<BetaMeasurement> XML = new XMLFormat<BetaMeasurement>(BetaMeasurement.class){

        @Override
        public BetaMeasurement newInstance(Class<BetaMeasurement> cls, XMLFormat.InputElement ie) throws XMLStreamException {
            return new BetaMeasurement(ie.getAttribute(BetaMeasurement.PROPERTY_ALPHA).toDouble(), ie.getAttribute(BetaMeasurement.PROPERTY_BETA).toDouble(), ie.getAttribute(BetaMeasurement.PROPERTY_MIN).toDouble(), ie.getAttribute(BetaMeasurement.PROPERTY_MAX).toDouble());
        }

        @Override
        public boolean isReferenceable() {
            return false;
        }

        @Override
        public void read(XMLFormat.InputElement ie, BetaMeasurement meas) throws XMLStreamException {
            meas.alpha = ie.getAttribute(BetaMeasurement.PROPERTY_ALPHA).toDouble();
            meas.beta = ie.getAttribute(BetaMeasurement.PROPERTY_BETA).toDouble();
            meas.min = ie.getAttribute(BetaMeasurement.PROPERTY_MIN).toDouble();
            meas.max = ie.getAttribute(BetaMeasurement.PROPERTY_MAX).toDouble();
        }

        @Override
        public void write(BetaMeasurement meas, XMLFormat.OutputElement oe) throws XMLStreamException {
            oe.setAttribute(BetaMeasurement.PROPERTY_ALPHA, meas.alpha);
            oe.setAttribute(BetaMeasurement.PROPERTY_BETA, meas.beta);
            oe.setAttribute(BetaMeasurement.PROPERTY_MIN, meas.min);
            oe.setAttribute(BetaMeasurement.PROPERTY_MAX, meas.max);
        }
    };

    public BetaMeasurement(double alpha, double beta, double min, double max) {
        assert (alpha > 0.0);
        assert (beta > 0.0);
        assert (min <= max);
        this.alpha = alpha;
        this.beta = beta;
        this.min = min;
        this.max = max;
    }

    public BetaMeasurement() {
        this.alpha = 2.0;
        this.beta = 2.0;
        this.min = 0.0;
        this.max = 1.0;
    }

    public Double getMax() {
        return this.max;
    }

    public void setMax(Double max) {
        assert (max >= this.min);
        Double oldval = this.max;
        this.max = max;
        this.firePropertyChange(PROPERTY_MAX, oldval, this.max);
    }

    public Double getMin() {
        return this.min;
    }

    public void setMin(Double min) {
        assert (min <= this.max);
        Double oldval = this.min;
        this.min = min;
        this.firePropertyChange(PROPERTY_MIN, oldval, this.min);
    }

    public Double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(Double alpha) {
        assert (alpha > 0.0);
        Double oldval = this.alpha;
        this.alpha = alpha;
        this.firePropertyChange(PROPERTY_ALPHA, oldval, this.alpha);
    }

    public Double getBeta() {
        return this.beta;
    }

    public void setBeta(Double beta) {
        assert (beta > 0.0);
        Double oldval = this.beta;
        this.beta = beta;
        this.firePropertyChange(PROPERTY_BETA, oldval, this.beta);
    }

    public Interval getRange() {
        BetaDistributionImpl dist = new BetaDistributionImpl(this.alpha, this.beta);
        try {
            double lowEnd = this.convertToRange(dist.inverseCumulativeProbability(0.025));
            double highEnd = this.convertToRange(dist.inverseCumulativeProbability(0.975));
            return new Interval(lowEnd, highEnd);
        }
        catch (MathException e) {
            throw new IllegalStateException("MathException in BetaMeasurement.getRange(): " + e.getMessage());
        }
    }

    private double convertToRange(double val) {
        return (val + this.min) * (this.max - this.min);
    }

    public double sample() {
        return RandomUtil.createBeta(this.min, this.max, this.alpha, this.beta);
    }

    public BetaMeasurement deepCopy() {
        return new BetaMeasurement(this.alpha, this.beta, this.min, this.max);
    }

    public String toString() {
        return "\u03b1: " + this.alpha + " \u03b2: " + this.beta + " min: " + this.min + " max: " + this.max;
    }

    public boolean equals(Object other) {
        if (!other.getClass().equals(BetaMeasurement.class)) {
            return false;
        }
        BetaMeasurement bo = (BetaMeasurement)other;
        return this.min.equals(bo.min) && this.max.equals(bo.max) && this.alpha.equals(bo.alpha) && this.beta.equals(bo.beta);
    }
}

