/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.components.IntervalPanel;
import fi.smaa.jsmaa.gui.presentation.ConstrainedIntervalValueModel;
import fi.smaa.jsmaa.model.Interval;
import fi.smaa.jsmaa.model.SMAATRIModel;
import java.awt.Component;
import javax.swing.JComponent;
import org.drugis.common.gui.ViewBuilder;

public class TechnicalParameterView
implements ViewBuilder {
    private SMAATRIModel model;

    public TechnicalParameterView(SMAATRIModel model) {
        this.model = model;
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("left:pref, 3dlu, left:pref:grow", "p, 3dlu, p, 3dlu, p");
        int fullWidth = 3;
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        builder.addSeparator("Model technical parameters", cc.xyw(1, 1, fullWidth));
        builder.addLabel("Lambda interval", cc.xy(1, 3));
        Interval range = new Interval(0.5, 1.0);
        String msg = "Lambda must be within range ";
        PresentationModel<Interval> imodel = new PresentationModel<Interval>(this.model.getLambda());
        IntervalPanel lambdaPanel = new IntervalPanel(new ConstrainedIntervalValueModel(null, this.model.getLambda(), imodel.getModel("start"), true, range, msg), new ConstrainedIntervalValueModel(null, this.model.getLambda(), imodel.getModel("end"), false, range, msg));
        builder.add((Component)lambdaPanel, cc.xy(3, 3));
        builder.addLabel("Exploitation rule", cc.xy(1, 5));
        builder.add((Component)BasicComponentFactory.createCheckBox(new PresentationModel<SMAATRIModel>(this.model).getModel("rule"), "(optimistic if checked, pessimistic otherwise)"), cc.xy(3, 5));
        return builder.getPanel();
    }
}

