/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jidesoft.swing.JideButton;
import fi.smaa.jsmaa.gui.GNUPlotDialog;
import fi.smaa.jsmaa.gui.jfreechart.PlotConverter;
import fi.smaa.jsmaa.gui.jfreechart.PlotConverterFactory;
import fi.smaa.jsmaa.gui.jfreechart.SMAADataSet;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.drugis.common.ImageLoader;
import org.drugis.common.gui.GUIHelper;
import org.drugis.common.gui.ViewBuilder;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.CategoryPlot;

public class ResultsView
implements ViewBuilder {
    private JTable table;
    private JFreeChart chart;
    private Window parent;
    private String scriptIcon;
    private boolean showChart;

    public ResultsView(Window parent, JTable table, JFreeChart chart, String scriptIcon, boolean showChart) {
        this.chart = chart;
        this.table = table;
        this.parent = parent;
        this.scriptIcon = scriptIcon;
        this.showChart = showChart;
    }

    public ResultsView(Window parent, JTable table, JFreeChart chart, String scriptIcon) {
        this.chart = chart;
        this.table = table;
        this.parent = parent;
        this.scriptIcon = scriptIcon;
        this.showChart = chart != null;
    }

    public JComponent buildPanel() {
        FormLayout layout = new FormLayout("pref", "p, 3dlu, p, 3dlu, p, 3dlu, p, 3dlu, p");
        PanelBuilder builder = new PanelBuilder(layout);
        builder.setDefaultDialogBorder();
        CellConstraints cc = new CellConstraints();
        JScrollPane spane = new JScrollPane(this.table);
        builder.add((Component)spane, cc.xy(1, 1));
        this.table.setPreferredScrollableViewportSize(this.table.getPreferredSize());
        builder.addSeparator("", cc.xy(1, 3));
        builder.add((Component)this.buildFigurePart(), cc.xy(1, 5));
        builder.add(this.buildExportButton(), cc.xy(1, 7, "left, center"));
        return builder.getPanel();
    }

    private Component buildExportButton() {
        JideButton exportButton = new JideButton("Export figure dataset as GNUPlot script", ImageLoader.getIcon(this.scriptIcon));
        exportButton.addActionListener(new AbstractAction(){

            public void actionPerformed(ActionEvent arg0) {
                PlotConverter c = PlotConverterFactory.getConverter((SMAADataSet)((Object)((CategoryPlot)ResultsView.this.chart.getPlot()).getDataset()));
                GNUPlotDialog d = new GNUPlotDialog(null, c);
                GUIHelper.centerWindow(d, ResultsView.this.parent);
                d.setVisible(true);
            }
        });
        return exportButton;
    }

    private JComponent buildFigurePart() {
        if (this.showChart) {
            ChartPanel chartPanel = new ChartPanel(this.chart);
            return chartPanel;
        }
        return new JLabel("Cannot show chart - column charts supported for up to 20 alternatives");
    }
}

