/*
 * Decompiled with CFR 0.152.
 */
package fi.smaa.jsmaa.gui.views;

import com.jgoodies.binding.PresentationModel;
import com.jgoodies.binding.adapter.BasicComponentFactory;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import fi.smaa.jsmaa.gui.components.MeasurementPanel;
import fi.smaa.jsmaa.model.Alternative;
import fi.smaa.jsmaa.model.CardinalMeasurement;
import fi.smaa.jsmaa.model.OutrankingCriterion;
import fi.smaa.jsmaa.model.SMAATRIModel;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JPanel;
import org.drugis.common.gui.LayoutUtil;
import org.drugis.common.gui.ViewBuilder;

public class ProfilesView
implements ViewBuilder {
    private SMAATRIModel model;
    private OutrankingCriterion crit;

    public ProfilesView(OutrankingCriterion crit, SMAATRIModel model) {
        this.crit = crit;
        this.model = model;
    }

    public JPanel buildPanel() {
        FormLayout layout = new FormLayout("right:pref, 1dlu, center:pref, 1dlu, right:pref, 3dlu, left:pref:grow", "p");
        PanelBuilder builder = new PanelBuilder(layout);
        CellConstraints cc = new CellConstraints();
        for (int aIndex = 0; aIndex < this.model.getCategories().size() - 1; ++aIndex) {
            Alternative a = this.model.getCategories().get(aIndex);
            if (aIndex != 0) {
                LayoutUtil.addRow(layout);
            }
            int row = 1 + aIndex * 2;
            builder.add((Component)BasicComponentFactory.createLabel(new PresentationModel<Alternative>(a).getModel("name")), cc.xy(1, row));
            builder.addLabel("-", cc.xy(3, row));
            builder.add((Component)BasicComponentFactory.createLabel(new PresentationModel<Alternative>(this.model.getCategories().get(aIndex + 1)).getModel("name")), cc.xy(5, row));
            ValueHolder holder = this.createMeasurementHolder(a);
            MeasurementPanel mpanel = new MeasurementPanel(holder, this.model.getImpactMatrix().getBaseline(this.crit));
            builder.add((Component)mpanel, cc.xy(7, row));
        }
        return builder.getPanel();
    }

    private ValueHolder createMeasurementHolder(Alternative prof) {
        ValueHolder holder = new ValueHolder(this.model.getCategoryUpperBound(this.crit, prof));
        holder.addPropertyChangeListener(new HolderListener(prof));
        return holder;
    }

    private class HolderListener
    implements PropertyChangeListener {
        private Alternative profile;

        public HolderListener(Alternative profile) {
            this.profile = profile;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ProfilesView.this.model.setMeasurement(ProfilesView.this.crit, this.profile, (CardinalMeasurement)evt.getNewValue());
        }
    }
}

